/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.metric;

import java.util.concurrent.atomic.LongAdder;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.metric.TimeCostInfo;

public class TrafficInfo {
    private final String groupId;
    private final String streamId;
    private final LongAdder syncSendPkgCnt = new LongAdder();
    private final LongAdder syncSendMsgCount = new LongAdder();
    private final LongAdder syncFailedPgkCount = new LongAdder();
    private final TimeCostInfo syncSendCostMs = new TimeCostInfo("sSucMs");
    private final LongAdder aSyncHttpPkgPutCnt = new LongAdder();
    private final LongAdder aSyncHttpMsgPutCnt = new LongAdder();
    private final LongAdder aSyncHttpFailPkgPutCnt = new LongAdder();
    private final LongAdder aSyncHttpPkgGetCnt = new LongAdder();
    private final LongAdder aSyncHttpMsgGetCnt = new LongAdder();
    private final LongAdder aSyncSendPkgCount = new LongAdder();
    private final LongAdder aSyncSendMsgCount = new LongAdder();
    private final LongAdder aSyncFailedPgkCnt = new LongAdder();
    private final LongAdder aRcvPkgCount = new LongAdder();
    private final LongAdder aRcvMsgCount = new LongAdder();
    private final LongAdder aRcvFailedPgkCount = new LongAdder();
    private final LongAdder aRcvFailedMsgCount = new LongAdder();
    private final TimeCostInfo asyncSucCostMs = new TimeCostInfo("aSucMs");
    private final LongAdder cbCallCount = new LongAdder();
    private final TimeCostInfo callbackCostMs = new TimeCostInfo("cbMs");

    public TrafficInfo(String groupId, String streamId) {
        this.groupId = groupId;
        this.streamId = streamId;
    }

    public void addSyncSucMsgInfo(int msgCnt, long costMs) {
        this.syncSendPkgCnt.increment();
        this.syncSendMsgCount.add(msgCnt);
        this.syncSendCostMs.addTimeCostInMs(costMs);
    }

    public void addSyncFailMsgInfo(int msgCnt) {
        this.syncFailedPgkCount.increment();
    }

    public void addAsyncSucSendInfo(int msgCnt) {
        this.aSyncSendPkgCount.increment();
        this.aSyncSendMsgCount.add(msgCnt);
    }

    public void addAsyncFailSendInfo(int msgCnt) {
        this.aSyncFailedPgkCnt.increment();
    }

    public void addAsyncHttpSucPutInfo(int msgCnt) {
        this.aSyncHttpPkgPutCnt.increment();
        this.aSyncHttpMsgPutCnt.add(msgCnt);
    }

    public void addAsyncHttpFailPutInfo(int msgCnt) {
        this.aSyncHttpFailPkgPutCnt.increment();
    }

    public void addAsyncHttpSucGetInfo(int msgCnt) {
        this.aSyncHttpPkgGetCnt.increment();
        this.aSyncHttpMsgGetCnt.add(msgCnt);
    }

    public void addAsyncSucRspInfo(int msgCnt, long sdCostMs, long cbCostMs) {
        this.aRcvPkgCount.increment();
        this.aRcvMsgCount.add(msgCnt);
        this.asyncSucCostMs.addTimeCostInMs(sdCostMs);
        this.cbCallCount.increment();
        this.callbackCostMs.addTimeCostInMs(cbCostMs);
    }

    public void addAsyncFailRspInfo(int msgCnt, long cbCostMs) {
        this.aRcvFailedPgkCount.increment();
        this.aRcvFailedMsgCount.add(msgCnt);
        this.cbCallCount.increment();
        this.callbackCostMs.addTimeCostInMs(cbCostMs);
    }

    public void getAndResetValue(StringBuilder strBuff) {
        strBuff.append("{\"gId\":\"").append(this.groupId);
        if (StringUtils.isNotBlank(this.streamId)) {
            strBuff.append("\",\"sId\":\"").append(this.streamId);
        }
        strBuff.append("\",\"sPs\":").append(this.syncSendPkgCnt.sumThenReset()).append(",\"sPf\":").append(this.syncFailedPgkCount.sumThenReset()).append(",\"sMs\":").append(this.syncSendMsgCount.sumThenReset()).append(",");
        this.syncSendCostMs.getAndResetValue(strBuff);
        strBuff.append(",\"apPs\":").append(this.aSyncHttpPkgPutCnt.sumThenReset()).append(",\"apPf\":").append(this.aSyncHttpFailPkgPutCnt.sumThenReset()).append(",\"agPs\":").append(this.aSyncHttpPkgGetCnt.sumThenReset()).append(",\"aPs\":").append(this.aSyncSendPkgCount.sumThenReset()).append(",\"aPf\":").append(this.aSyncFailedPgkCnt.sumThenReset()).append(",\"arPs\":").append(this.aRcvPkgCount.sumThenReset()).append(",\"arPf\":").append(this.aRcvFailedPgkCount.sumThenReset()).append(",\"cbCt\":").append(this.cbCallCount.sumThenReset()).append(",\"apMs\":").append(this.aSyncHttpMsgPutCnt.sumThenReset()).append(",\"agMs\":").append(this.aSyncHttpMsgGetCnt.sumThenReset()).append(",\"aMs\":").append(this.aSyncSendMsgCount.sumThenReset()).append(",\"arMs\":").append(this.aRcvMsgCount.sumThenReset()).append(",\"arMf\":").append(this.aRcvFailedMsgCount.sumThenReset()).append(",");
        this.asyncSucCostMs.getAndResetValue(strBuff);
        strBuff.append(",");
        this.callbackCostMs.getAndResetValue(strBuff);
        strBuff.append("}");
    }

    public void clear() {
        this.syncSendPkgCnt.reset();
        this.syncSendMsgCount.reset();
        this.syncFailedPgkCount.reset();
        this.syncSendCostMs.clear();
        this.aSyncSendPkgCount.reset();
        this.aSyncSendMsgCount.reset();
        this.aSyncFailedPgkCnt.reset();
        this.aSyncHttpPkgPutCnt.reset();
        this.aSyncHttpMsgPutCnt.reset();
        this.aSyncHttpFailPkgPutCnt.reset();
        this.aSyncHttpPkgGetCnt.reset();
        this.aSyncHttpMsgGetCnt.reset();
        this.aRcvPkgCount.reset();
        this.aRcvMsgCount.reset();
        this.aRcvFailedPgkCount.reset();
        this.aRcvFailedMsgCount.reset();
        this.asyncSucCostMs.clear();
        this.cbCallCount.reset();
        this.callbackCostMs.clear();
    }
}

