/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.reporter;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.Map;
import org.apache.inlong.audit.tool.metric.AuditMetric;
import org.apache.inlong.audit.tool.reporter.MetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusReporter
implements MetricReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusReporter.class);
    private final CollectorRegistry registry = new CollectorRegistry();
    private final AuditMetric auditMetric = new AuditMetric(this.registry);

    public void init(Map<String, Object> config) {
        int port = (Integer)config.getOrDefault("prometheus.port", 9091);
        try {
            HTTPServer server = new HTTPServer.Builder().withPort(port).withRegistry(this.registry).build();
            LOGGER.info("Prometheus server started on port {}", (Object)port);
            Gauge alertGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("audit_tool_alerts_total")).help("Total number of alerts")).labelNames(new String[]{"group_id", "stream_id", "alert_type"})).register(this.registry);
            Gauge gauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("audit_tool_data_loss_rate")).help("Data loss rate between Sort and DataProxy")).labelNames(new String[]{"group_id", "stream_id"})).register(this.registry);
        }
        catch (IOException e) {
            LOGGER.error("Failed to start Prometheus server on port {}", (Object)port, (Object)e);
            throw new RuntimeException("Failed to start Prometheus server", e);
        }
    }

    public AuditMetric getAuditMetric() {
        return this.auditMetric;
    }
}

