/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class AppConfig {
    private final Properties properties = new Properties();

    public AppConfig() {
        this.loadProperties();
    }

    private void loadProperties() {
        try {
            this.properties.load(this.getClass().getClassLoader().getResourceAsStream("application.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load application properties", e);
        }
    }

    public String getManagerUrl() {
        return this.properties.getProperty("manager.url");
    }

    public Map<String, Object> getPrometheusConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("prometheus.enabled", Boolean.parseBoolean(this.properties.getProperty("prometheus.enabled", "false")));
        config.put("prometheus.endpoint", this.properties.getProperty("prometheus.endpoint", "http://localhost:9090/api/v1/write"));
        config.put("prometheus.port", Integer.parseInt(this.properties.getProperty("prometheus.port", String.valueOf(9091))));
        return config;
    }

    public String getSecretId() {
        return this.properties.getProperty("audit.secretId");
    }

    public String getSecretKey() {
        return this.properties.getProperty("audit.secretKey");
    }

    public Properties getProperties() {
        return this.properties;
    }
}

