/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit;

import org.apache.inlong.audit.entity.AuditType;
import org.apache.inlong.audit.entity.FlowType;
import org.apache.inlong.audit.exceptions.AuditTypeNotExistException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AuditIdEnum {
    SDK_INPUT(1, FlowType.INPUT, AuditType.SDK, "Received Audit Metrics for SDK"),
    SDK_OUTPUT(2, FlowType.OUTPUT, AuditType.SDK, "Sent Audit Metrics for SDK"),
    AGENT_INPUT(3, FlowType.INPUT, AuditType.AGENT, "Received Audit Metrics for Agent"),
    AGENT_OUTPUT(4, FlowType.OUTPUT, AuditType.AGENT, "Sent Audit Metrics for Agent"),
    DATA_PROXY_INPUT(5, FlowType.INPUT, AuditType.DATAPROXY, "Received Audit Metrics for DataProxy"),
    DATA_PROXY_OUTPUT(6, FlowType.OUTPUT, AuditType.DATAPROXY, "Sent Audit Metrics for DataProxy"),
    SORT_HIVE_INPUT(7, FlowType.INPUT, AuditType.HIVE, "Received Audit Metrics for Sort Hive"),
    SORT_HIVE_OUTPUT(8, FlowType.OUTPUT, AuditType.HIVE, "Sent Audit Metrics for Sort Hive"),
    SORT_CLICKHOUSE_INPUT(9, FlowType.INPUT, AuditType.CLICKHOUSE, "Received Audit Metrics for Sort ClickHouse"),
    SORT_CLICKHOUSE_OUTPUT(10, FlowType.OUTPUT, AuditType.CLICKHOUSE, "Sent Audit Metrics for Sort ClickHouse"),
    SORT_ELASTICSEARCH_INPUT(11, FlowType.INPUT, AuditType.ELASTICSEARCH, "Received Audit Metrics for Sort ElasticSearch"),
    SORT_ELASTICSEARCH_OUTPUT(12, FlowType.OUTPUT, AuditType.ELASTICSEARCH, "Sent Audit Metrics for Sort ElasticSearch"),
    SORT_STARROCKS_INPUT(13, FlowType.INPUT, AuditType.STARROCKS, "Received Audit Metrics for Sort StarRocks"),
    SORT_STARROCKS_OUTPUT(14, FlowType.OUTPUT, AuditType.STARROCKS, "Sent Audit Metrics for Sort StarRocks"),
    SORT_HUDI_INPUT(15, FlowType.INPUT, AuditType.HUDI, "Received Audit Metrics for Sort HuDi"),
    SORT_HUDI_OUTPUT(16, FlowType.OUTPUT, AuditType.HUDI, "Sent Audit Metrics for Sort HuDi"),
    SORT_ICEBERG_INPUT(17, FlowType.INPUT, AuditType.ICEBERG, "Received Audit Metrics for Sort Iceberg"),
    SORT_ICEBERG_OUTPUT(18, FlowType.OUTPUT, AuditType.ICEBERG, "Sent Audit Metrics for Sort Iceberg"),
    SORT_HBASE_INPUT(19, FlowType.INPUT, AuditType.HBASE, "Received Audit Metrics for Sort HBase"),
    SORT_HBASE_OUTPUT(20, FlowType.OUTPUT, AuditType.HBASE, "Sent Audit Metrics for Sort HBase"),
    SORT_DORIS_INPUT(21, FlowType.INPUT, AuditType.DORIS, "Received Audit Metrics for Sort Doris"),
    SORT_DORIS_OUTPUT(22, FlowType.OUTPUT, AuditType.DORIS, "Sent Audit Metrics for Sort Doris"),
    SORT_KUDU_INPUT(25, FlowType.INPUT, AuditType.KUDU, "Received Audit Metrics for Sort Kudu"),
    SORT_KUDU_OUTPUT(26, FlowType.OUTPUT, AuditType.KUDU, "Sent Audit Metrics for Sort Kudu"),
    SORT_POSTGRES_INPUT(27, FlowType.INPUT, AuditType.POSTGRES, "Received Audit Metrics for Sort Postgres"),
    SORT_POSTGRES_OUTPUT(28, FlowType.OUTPUT, AuditType.POSTGRES, "Sent Audit Metrics for Sort Postgres"),
    SORT_BINLOG_INPUT(35, FlowType.INPUT, AuditType.BINLOG, "Received Audit Metrics for Sort Binlog"),
    SORT_BINLOG_OUTPUT(36, FlowType.OUTPUT, AuditType.BINLOG, "Sent Audit Metrics for Sort Binlog"),
    SORT_TUBE_INPUT(33, FlowType.INPUT, AuditType.TUBEMQ, "Received Audit Metrics for Sort TubeMQ"),
    SORT_TUBE_OUTPUT(34, FlowType.OUTPUT, AuditType.TUBEMQ, "Sent Audit Metrics for Sort TubeMQ"),
    SORT_MYSQL_INPUT(35, FlowType.INPUT, AuditType.MYSQL, "Received Audit Metrics for Sort MySQL"),
    SORT_MYSQL_OUTPUT(36, FlowType.OUTPUT, AuditType.MYSQL, "Sent Audit Metrics for Sort MySQL"),
    SORT_HDFS_INPUT(37, FlowType.INPUT, AuditType.HDFS, "Received Audit Metrics for Sort HDFS"),
    SORT_HDFS_OUTPUT(38, FlowType.OUTPUT, AuditType.HDFS, "Sent Audit Metrics for Sort HDFS"),
    SORT_TDSQL_MYSQL_INPUT(39, FlowType.INPUT, AuditType.TDSQL_MYSQL, "Received Audit Metrics for TDSQL MYSQL"),
    SORT_TDSQL_MYSQL_OUTPUT(40, FlowType.OUTPUT, AuditType.TDSQL_MYSQL, "Sent Audit Metrics for TDSQL MYSQL"),
    BSS_INPUT(41, FlowType.INPUT, AuditType.BSS, "Received Audit Metrics for BSS"),
    BSS_OUTPUT(42, FlowType.OUTPUT, AuditType.BSS, "Sent Audit Metrics for BSS"),
    ICEBERG_AO_INPUT(43, FlowType.INPUT, AuditType.ICEBERG_AO, "Received Audit Metrics for ICEBERG AO"),
    ICEBERG_AO_OUTPUT(44, FlowType.OUTPUT, AuditType.ICEBERG_AO, "Sent Audit Metrics for ICEBERG AO");

    private static final Logger LOGGER;
    private final int auditId;
    private final String description;
    private final FlowType flowType;
    private final AuditType auditType;

    private AuditIdEnum(int auditId, FlowType flowType, AuditType auditType, String description) {
        this.auditId = auditId;
        this.description = description;
        this.flowType = flowType;
        this.auditType = auditType;
    }

    public int getValue() {
        return this.auditId;
    }

    public String getDescription() {
        return this.description;
    }

    public FlowType getFlowType() {
        return this.flowType;
    }

    public AuditType getAuditType() {
        return this.auditType;
    }

    public static AuditIdEnum getAuditId(String auditType, FlowType flowType) {
        for (AuditIdEnum auditIdEnum : AuditIdEnum.values()) {
            if (auditIdEnum.getFlowType() != flowType || !auditType.equalsIgnoreCase(auditIdEnum.getAuditType().value())) continue;
            return auditIdEnum;
        }
        LOGGER.error("Error Audit type: {}, flow type {}: ", (Object)auditType, (Object)flowType);
        throw new AuditTypeNotExistException(String.format("Audit type %s does not exist", auditType));
    }

    static {
        LOGGER = LoggerFactory.getLogger(AuditIdEnum.class);
    }
}

