/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

public enum IndicatorType {
    RECEIVED_SUCCESS(0, "RECEIVED_SUCCESS", "Message received success"),
    SEND_SUCCESS(1, "SEND_SUCCESS", "Message send success"),
    RECEIVED_FAILED(2, "RECEIVED_FAILED", "Message received failed"),
    SEND_FAILED(3, "SEND_FAILED", "Message send failed"),
    RECEIVED_RETRY(4, "RECEIVED_RETRY", "Message received retry"),
    SEND_RETRY(5, "SEND_RETRY", "Message send retry"),
    RECEIVED_DISCARD(6, "RECEIVED_DISCARD", "Message received discard"),
    SEND_DISCARD(7, "SEND_DISCARD", "Message send discard"),
    UNKNOWN_TYPE(Integer.MAX_VALUE, "UNKNOWN_TYPE", "Unknown type");

    private final int code;
    private final String name;
    private final String desc;

    private IndicatorType(int code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public static IndicatorType valueOf(int value) {
        for (IndicatorType code : IndicatorType.values()) {
            if (code.getCode() != value) continue;
            return code;
        }
        return UNKNOWN_TYPE;
    }

    public static Boolean isSuccessType(IndicatorType indicatorType) {
        return !RECEIVED_FAILED.equals((Object)indicatorType) && !SEND_FAILED.equals((Object)indicatorType);
    }

    public static Boolean isDiscardType(IndicatorType indicatorType) {
        return RECEIVED_DISCARD.equals((Object)indicatorType) || SEND_DISCARD.equals((Object)indicatorType);
    }

    public static Boolean isRetryType(IndicatorType indicatorType) {
        return RECEIVED_RETRY.equals((Object)indicatorType) || SEND_RETRY.equals((Object)indicatorType);
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }
}

