/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils;

import io.debezium.spi.converter.CustomConverter;
import io.debezium.spi.converter.RelationalColumn;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.inlong.agent.plugin.utils.PluginUtils;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogTimeConverter
implements CustomConverter<SchemaBuilder, RelationalColumn> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginUtils.class);
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_DATE;
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_TIME;
    private DateTimeFormatter datetimeFormatter = DateTimeFormatter.ISO_DATE_TIME;
    private DateTimeFormatter timestampFormatter = DateTimeFormatter.ISO_DATE_TIME;
    private ZoneId timestampZoneId = ZoneId.systemDefault();

    public void configure(Properties props) {
        this.readProps(props, "format.date", p -> {
            this.dateFormatter = DateTimeFormatter.ofPattern(p);
        });
        this.readProps(props, "format.time", p -> {
            this.timeFormatter = DateTimeFormatter.ofPattern(p);
        });
        this.readProps(props, "format.datetime", p -> {
            this.datetimeFormatter = DateTimeFormatter.ofPattern(p);
        });
        this.readProps(props, "format.timestamp", p -> {
            this.timestampFormatter = DateTimeFormatter.ofPattern(p);
        });
        this.readProps(props, "format.timestamp.zone", z -> {
            this.timestampZoneId = ZoneId.of(z);
        });
    }

    private void readProps(Properties properties, String settingKey, Consumer<String> callback) {
        String settingValue = (String)properties.get(settingKey);
        if (settingValue == null || settingValue.length() == 0) {
            return;
        }
        try {
            callback.accept(settingValue.trim());
        }
        catch (IllegalArgumentException | DateTimeException e) {
            LOGGER.error("The {} setting is illegal:{}", (Object)settingKey, (Object)settingValue);
            throw e;
        }
    }

    public void converterFor(RelationalColumn column, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
        String sqlType = column.typeName().toUpperCase();
        SchemaBuilder schemaBuilder = null;
        CustomConverter.Converter converter = null;
        if ("DATE".equals(sqlType)) {
            schemaBuilder = SchemaBuilder.string().optional().name("org.apache.inlong.agent.date.string");
            converter = this::convertDate;
        }
        if ("TIME".equals(sqlType)) {
            schemaBuilder = SchemaBuilder.string().optional().name("org.apache.inlong.agent.time.string");
            converter = this::convertTime;
        }
        if ("DATETIME".equals(sqlType)) {
            schemaBuilder = SchemaBuilder.string().optional().name("org.apache.inlong.agent.datetime.string");
            converter = this::convertDateTime;
        }
        if ("TIMESTAMP".equals(sqlType)) {
            schemaBuilder = SchemaBuilder.string().optional().name("org.apache.inlong.agent.timestamp.string");
            converter = this::convertTimestamp;
        }
        if (schemaBuilder != null) {
            registration.register((Object)schemaBuilder, converter);
            LOGGER.info("register converter for sqlType {} to schema {}", (Object)sqlType, (Object)schemaBuilder.name());
        }
    }

    private String convertDate(Object input) {
        if (input instanceof LocalDate) {
            return this.dateFormatter.format((LocalDate)input);
        }
        if (input instanceof Integer) {
            LocalDate date = LocalDate.ofEpochDay(((Integer)input).intValue());
            return this.dateFormatter.format(date);
        }
        return input == null ? null : input.toString();
    }

    private String convertTime(Object input) {
        if (input instanceof Duration) {
            Duration duration = (Duration)input;
            long seconds = duration.getSeconds();
            int nano = duration.getNano();
            LocalTime time = LocalTime.ofSecondOfDay(seconds).withNano(nano);
            return this.timeFormatter.format(time);
        }
        return input == null ? null : input.toString();
    }

    private String convertDateTime(Object input) {
        if (input instanceof LocalDateTime) {
            return this.datetimeFormatter.format((LocalDateTime)input);
        }
        return input == null ? null : input.toString();
    }

    private String convertTimestamp(Object input) {
        if (input instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)input;
            LocalDateTime localDateTime = zonedDateTime.withZoneSameInstant(this.timestampZoneId).toLocalDateTime();
            return this.timestampFormatter.format(localDateTime);
        }
        return input == null ? null : input.toString();
    }
}

