/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.message.file.ProxyMessageCache;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.plugin.file.Sink;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSink
implements Sink {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSink.class);
    protected String inlongGroupId;
    protected String inlongStreamId;
    protected AgentMetricItemSet metricItemSet;
    protected AgentMetricItem sinkMetric;
    protected Map<String, String> dimensions;
    protected static final AtomicLong METRIC_INDEX = new AtomicLong(0L);
    protected InstanceProfile profile;
    protected String sourceName;
    protected String jobInstanceId;
    protected int batchFlushInterval;
    protected ProxyMessageCache cache;
    private static final AgentConfiguration agentConf = AgentConfiguration.getAgentConf();

    public void setSourceName(String sourceFileName) {
        this.sourceName = sourceFileName;
    }

    public void init(InstanceProfile profile) {
        this.profile = profile;
        this.jobInstanceId = profile.getInstanceId();
        this.inlongGroupId = profile.getInlongGroupId();
        this.inlongStreamId = profile.getInlongStreamId();
        this.cache = new ProxyMessageCache(this.profile, this.inlongGroupId, this.inlongStreamId);
        this.batchFlushInterval = agentConf.getInt("proxy.batch.flush.interval", 1);
        this.dimensions = new HashMap<String, String>();
        this.dimensions.put("pluginId", this.getClass().getSimpleName());
        this.dimensions.put("inlongGroupId", this.inlongGroupId);
        this.dimensions.put("inlongStreamId", this.inlongStreamId);
        String metricName = String.join((CharSequence)"-", this.getClass().getSimpleName(), String.valueOf(METRIC_INDEX.incrementAndGet()));
        this.metricItemSet = new AgentMetricItemSet(metricName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
        this.sinkMetric = (AgentMetricItem)this.metricItemSet.findMetricItem(this.dimensions);
    }
}

