/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils;

import io.debezium.spi.converter.CustomConverter;
import io.debezium.spi.converter.RelationalColumn;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.function.Consumer;
import microsoft.sql.DateTimeOffset;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerTimeConverter
implements CustomConverter<SchemaBuilder, RelationalColumn> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerTimeConverter.class);
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_DATE;
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_TIME;
    private DateTimeFormatter datetimeFormatter = DateTimeFormatter.ISO_DATE_TIME;
    private ZoneOffset defalutZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(Instant.now());

    public void configure(Properties props) {
        this.readProps(props, "format.date", p -> {
            this.dateFormatter = DateTimeFormatter.ofPattern(p);
        });
        this.readProps(props, "format.time", p -> {
            this.timeFormatter = DateTimeFormatter.ofPattern(p);
        });
        this.readProps(props, "format.datetime", p -> {
            this.datetimeFormatter = DateTimeFormatter.ofPattern(p);
        });
        this.readProps(props, "format.timestamp.zone", z -> {
            this.defalutZoneOffset = ZoneOffset.of(z);
        });
    }

    private void readProps(Properties properties, String settingKey, Consumer<String> callback) {
        String settingValue = (String)properties.get(settingKey);
        if (settingValue == null || settingValue.length() == 0) {
            return;
        }
        try {
            callback.accept(settingValue.trim());
        }
        catch (IllegalArgumentException | DateTimeException e) {
            LOGGER.error("The {} setting is illegal:{}", (Object)settingKey, (Object)settingValue);
            throw e;
        }
    }

    public void converterFor(RelationalColumn column, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
        String sqlType = column.typeName().toUpperCase();
        SchemaBuilder schemaBuilder = null;
        CustomConverter.Converter converter = null;
        if ("DATE".equals(sqlType)) {
            schemaBuilder = SchemaBuilder.string().optional().name("org.apache.inlong.agent.date.string");
            converter = this::convertDate;
        }
        if ("TIME".equals(sqlType)) {
            schemaBuilder = SchemaBuilder.string().optional().name("org.apache.inlong.agent.time.string");
            converter = this::convertTime;
        }
        if ("DATETIME".equals(sqlType) || "DATETIME2".equals(sqlType) || "SMALLDATETIME".equals(sqlType)) {
            schemaBuilder = SchemaBuilder.string().optional().name("org.apache.inlong.agent.datetime.string");
            converter = this::convertDateTime;
        }
        if ("DATETIMEOFFSET".equals(sqlType)) {
            schemaBuilder = SchemaBuilder.string().optional().name("org.apache.inlong.agent.datetimeoffset.string");
            converter = this::convertDateTimeOffset;
        }
        if (schemaBuilder != null) {
            registration.register((Object)schemaBuilder, converter);
            LOGGER.info("register converter for sqlType {} to schema {}", (Object)sqlType, (Object)schemaBuilder.name());
        }
    }

    private String convertDate(Object input) {
        if (input instanceof Date) {
            return this.dateFormatter.format(((Date)input).toLocalDate());
        }
        return input == null ? null : input.toString();
    }

    private String convertTime(Object input) {
        if (input instanceof Time) {
            return this.timeFormatter.format(((Time)input).toLocalTime());
        }
        if (input instanceof Timestamp) {
            return this.timeFormatter.format(((Timestamp)input).toLocalDateTime().toLocalTime());
        }
        return input == null ? null : input.toString();
    }

    private String convertDateTime(Object input) {
        if (input instanceof Timestamp) {
            return this.datetimeFormatter.format(((Timestamp)input).toLocalDateTime());
        }
        return input == null ? null : input.toString();
    }

    private String convertDateTimeOffset(Object input) {
        if (input instanceof DateTimeOffset) {
            DateTimeOffset dateTimeOffset = (DateTimeOffset)input;
            return this.datetimeFormatter.format(dateTimeOffset.getOffsetDateTime().withOffsetSameInstant(this.defalutZoneOffset).toLocalDateTime());
        }
        return input == null ? null : input.toString();
    }
}

