/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.fetcher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.ProfileFetcher;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.plugin.fetcher.ManagerResultFormatter;
import org.apache.inlong.agent.pojo.FileTask;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.EventReportUtils;
import org.apache.inlong.agent.utils.HttpManager;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.enums.PullJobTypeEnum;
import org.apache.inlong.common.enums.TaskTypeEnum;
import org.apache.inlong.common.pojo.agent.AgentConfigInfo;
import org.apache.inlong.common.pojo.agent.AgentConfigRequest;
import org.apache.inlong.common.pojo.agent.AgentResponseCode;
import org.apache.inlong.common.pojo.agent.DataConfig;
import org.apache.inlong.common.pojo.agent.TaskRequest;
import org.apache.inlong.common.pojo.agent.TaskResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerFetcher
extends AbstractDaemon
implements ProfileFetcher {
    public static final String AGENT = "agent";
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerFetcher.class);
    private static final GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Gson GSON = gsonBuilder.create();
    private final String baseManagerUrl;
    private final String staticConfigUrl;
    private final String agentConfigInfoUrl;
    private final AgentConfiguration conf;
    private final String uniqId;
    private final AgentManager agentManager;
    private final HttpManager httpManager;
    private String localIp;
    private String uuid;
    private String clusterTag;
    private String clusterName;

    public ManagerFetcher(AgentManager agentManager) {
        this.agentManager = agentManager;
        this.conf = AgentConfiguration.getAgentConf();
        if (!this.requiredKeys(this.conf)) {
            throw new RuntimeException("init manager error, cannot find required key");
        }
        this.httpManager = new HttpManager(this.conf);
        this.baseManagerUrl = this.httpManager.getBaseUrl();
        this.staticConfigUrl = this.buildStaticConfigUrl(this.baseManagerUrl);
        this.agentConfigInfoUrl = this.buildAgentConfigInfoUrl(this.baseManagerUrl);
        this.uniqId = this.conf.get("agent.uniq.id", AgentConstants.DEFAULT_AGENT_UNIQ_ID);
        this.clusterTag = this.conf.get("agent.cluster.tag");
        this.clusterName = this.conf.get("agent.cluster.name");
    }

    private boolean requiredKeys(AgentConfiguration conf) {
        return conf.hasKey("agent.manager.addr");
    }

    private String buildStaticConfigUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.task.http.path", "/agent/getExistTaskConfig");
    }

    private String buildAgentConfigInfoUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.config.http.path", "/agent/getConfig");
    }

    public TaskResult getStaticConfig() {
        LOGGER.info("Get static config start");
        String resultStr = this.httpManager.doSentPost(this.staticConfigUrl, (Object)this.getTaskRequest());
        LOGGER.info("Url to get static config staticConfigUrl {}", (Object)this.staticConfigUrl);
        JsonObject resultData = ManagerResultFormatter.getResultData(resultStr);
        JsonElement element = resultData.get("data");
        LOGGER.info("Get static config  end");
        if (element != null) {
            LOGGER.info("Get static config not null {}", (Object)resultData);
            return (TaskResult)GSON.fromJson((JsonElement)element.getAsJsonObject(), TaskResult.class);
        }
        LOGGER.info("Get static config nothing to do");
        return null;
    }

    public AgentConfigInfo getAgentConfigInfo() {
        LOGGER.info("Get agent config info");
        String resultStr = this.httpManager.doSentPost(this.agentConfigInfoUrl, (Object)this.getAgentConfigInfoRequest());
        LOGGER.info("Url to get agent config agentConfigInfoUrl {}", (Object)this.agentConfigInfoUrl);
        JsonObject resultData = ManagerResultFormatter.getResultData(resultStr);
        JsonElement element = resultData.get("data");
        LOGGER.info("Get agent config end");
        if (element != null) {
            LOGGER.info("Get agent config not null {}", (Object)resultData);
            return (AgentConfigInfo)GSON.fromJson((JsonElement)element.getAsJsonObject(), AgentConfigInfo.class);
        }
        LOGGER.info("Get agent config nothing to do");
        return null;
    }

    public TaskRequest getTaskRequest() {
        TaskRequest request = new TaskRequest();
        request.setMd5(this.agentManager.getTaskManager().getTaskResultMd5());
        request.setAgentIp(this.localIp);
        request.setUuid(this.uuid);
        request.setClusterName(this.clusterName);
        request.setPullJobType(PullJobTypeEnum.NEW.getType());
        request.setCommandInfo(null);
        return request;
    }

    public AgentConfigRequest getAgentConfigInfoRequest() {
        AgentConfigRequest request = new AgentConfigRequest();
        if (AgentManager.getAgentConfigInfo() != null) {
            request.setMd5(AgentManager.getAgentConfigInfo().getMd5());
        }
        request.setClusterTag(this.clusterTag);
        request.setClusterName(this.clusterName);
        request.setIp(this.localIp);
        return request;
    }

    private Runnable configFetchThread() {
        return () -> {
            Thread.currentThread().setName("ManagerFetcher");
            while (this.isRunnable()) {
                try {
                    AgentConfigInfo config2;
                    TaskResult taskResult = this.getStaticConfig();
                    if (taskResult != null) {
                        if (taskResult.getCode().equals((Object)AgentResponseCode.SUCCESS)) {
                            if (this.agentManager.getTaskManager().getTaskResultVersion() < taskResult.getVersion()) {
                                EventReportUtils.report((String)"", (String)"", (long)AgentUtils.getCurrentTime(), (String)"CONFIG_UPDATE", (String)"INFO", (EventReportUtils.EvenCodeEnum)EventReportUtils.EvenCodeEnum.CONFIG_UPDATE_SUC, (String)taskResult.toString(), (String)EventReportUtils.EvenCodeEnum.CONFIG_UPDATE_SUC.getMessage());
                                ArrayList taskProfiles = new ArrayList();
                                taskResult.getDataConfigs().forEach(config -> {
                                    TaskProfile profile = TaskProfile.convertToTaskProfile((DataConfig)config);
                                    taskProfiles.add(profile);
                                });
                                this.agentManager.getTaskManager().submitTaskProfiles(taskProfiles);
                                this.agentManager.getTaskManager().setTaskResultMd5(taskResult.getMd5());
                                this.agentManager.getTaskManager().setTaskResultVersion(taskResult.getVersion());
                            } else {
                                EventReportUtils.report((String)"", (String)"", (long)AgentUtils.getCurrentTime(), (String)"CONFIG_UPDATE", (String)"WARN", (EventReportUtils.EvenCodeEnum)EventReportUtils.EvenCodeEnum.CONFIG_UPDATE_VERSION_NO_CHANGE, (String)taskResult.toString(), (String)EventReportUtils.EvenCodeEnum.CONFIG_UPDATE_VERSION_NO_CHANGE.getMessage());
                                LOGGER.warn("%s: %s", (Object)EventReportUtils.EvenCodeEnum.CONFIG_UPDATE_VERSION_NO_CHANGE.getMessage(), (Object)taskResult);
                            }
                        } else if (taskResult.getCode().equals((Object)AgentResponseCode.NO_UPDATE)) {
                            EventReportUtils.report((String)"", (String)"", (long)AgentUtils.getCurrentTime(), (String)"CONFIG_UPDATE", (String)"INFO", (EventReportUtils.EvenCodeEnum)EventReportUtils.EvenCodeEnum.CONFIG_NO_UPDATE, (String)taskResult.toString(), (String)EventReportUtils.EvenCodeEnum.CONFIG_NO_UPDATE.getMessage());
                        } else {
                            EventReportUtils.report((String)"", (String)"", (long)AgentUtils.getCurrentTime(), (String)"CONFIG_UPDATE", (String)"ERROR", (EventReportUtils.EvenCodeEnum)EventReportUtils.EvenCodeEnum.CONFIG_INVALID_RET_CODE, (String)taskResult.toString(), (String)EventReportUtils.EvenCodeEnum.CONFIG_INVALID_RET_CODE.getMessage());
                        }
                    } else {
                        EventReportUtils.report((String)"", (String)"", (long)AgentUtils.getCurrentTime(), (String)"CONFIG_UPDATE", (String)"ERROR", (EventReportUtils.EvenCodeEnum)EventReportUtils.EvenCodeEnum.CONFIG_INVALID_RESULT, (String)taskResult.toString(), (String)EventReportUtils.EvenCodeEnum.CONFIG_INVALID_RESULT.getMessage());
                    }
                    if ((config2 = this.getAgentConfigInfo()) == null || !config2.getCode().equals((Object)AgentResponseCode.SUCCESS) || AgentManager.getAgentConfigInfo() != null && AgentManager.getAgentConfigInfo().getVersion() >= config2.getVersion()) continue;
                    this.agentManager.subNewAgentConfigInfo(config2);
                }
                catch (Throwable ex) {
                    EventReportUtils.report((String)"", (String)"", (long)AgentUtils.getCurrentTime(), (String)"CONFIG_UPDATE", (String)"ERROR", (EventReportUtils.EvenCodeEnum)EventReportUtils.EvenCodeEnum.CONFIG_INVALID_RESULT, (String)ex.getMessage(), (String)EventReportUtils.EvenCodeEnum.CONFIG_INVALID_RESULT.getMessage());
                    LOGGER.warn("exception caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
                finally {
                    AgentUtils.silenceSleepInSeconds((long)AgentUtils.getRandomBySeed((int)this.conf.getInt("agent.fetcher.interval", 60)));
                }
            }
        };
    }

    private TaskResult getTestConfig(String testDir, int normalTaskId, int retryTaskId, int state) {
        ArrayList<DataConfig> configs = new ArrayList<DataConfig>();
        String normalPattern = testDir + "YYYY/YYYYMMDDhhmm_2.log_[0-9]+";
        String retryPattern = testDir + "YYYY/YYYYMMDD_1.log_[0-9]+";
        configs.add(this.getTestDataConfig(normalTaskId, normalPattern, false, "202307100000", "202307220000", "m", state));
        configs.add(this.getTestDataConfig(retryTaskId, retryPattern, true, "20230710", "20230722", "d", state));
        return TaskResult.builder().dataConfigs(configs).build();
    }

    private DataConfig getTestDataConfig(int taskId, String pattern, boolean retry, String startTime, String endTime, String cycleUnit, int state) {
        DataConfig dataConfig = new DataConfig();
        dataConfig.setInlongGroupId("devcloud_group_id");
        dataConfig.setInlongStreamId("devcloud_stream_id");
        dataConfig.setDataReportType(Integer.valueOf(0));
        dataConfig.setTaskType(Integer.valueOf(TaskTypeEnum.FILE.getType()));
        dataConfig.setTaskId(Integer.valueOf(taskId));
        dataConfig.setState(Integer.valueOf(state));
        dataConfig.setTimeZone("GMT+8:00");
        FileTask.FileTaskConfig fileTaskConfig = new FileTask.FileTaskConfig();
        fileTaskConfig.setPattern(pattern);
        fileTaskConfig.setTimeOffset("0d");
        fileTaskConfig.setMaxFileCount(Integer.valueOf(100));
        fileTaskConfig.setCycleUnit(cycleUnit);
        fileTaskConfig.setRetry(Boolean.valueOf(retry));
        fileTaskConfig.setDataTimeFrom(startTime);
        fileTaskConfig.setDataTimeTo(endTime);
        fileTaskConfig.setDataContentStyle("CSV");
        fileTaskConfig.setDataSeparator("|");
        dataConfig.setExtParams(GSON.toJson((Object)fileTaskConfig));
        return dataConfig;
    }

    public void start() throws Exception {
        this.localIp = this.conf.get("agent.local.ip");
        this.uuid = AgentUtils.fetchLocalUuid();
        this.submitWorker(this.configFetchThread());
    }

    public void stop() {
        this.waitForTerminate();
    }
}

