/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.slf4j;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
implements IgniteLogger {
    private final Logger impl;
    private final boolean quiet;

    public Slf4jLogger() {
        this(LoggerFactory.getLogger((String)"ROOT"));
    }

    public Slf4jLogger(Logger impl) {
        assert (impl != null);
        this.impl = impl;
        this.quiet = Boolean.valueOf(System.getProperty("IGNITE_QUIET", "true"));
    }

    public Slf4jLogger getLogger(Object ctgr) {
        Logger impl = ctgr == null ? LoggerFactory.getLogger((String)"ROOT") : (ctgr instanceof Class ? LoggerFactory.getLogger((String)((Class)ctgr).getName()) : LoggerFactory.getLogger((String)ctgr.toString()));
        return new Slf4jLogger(impl);
    }

    public void trace(String msg) {
        if (!this.impl.isTraceEnabled()) {
            this.warning("Logging at TRACE level without checking if TRACE level is enabled: " + msg);
        }
        this.impl.trace(msg);
    }

    public void debug(String msg) {
        if (!this.impl.isDebugEnabled()) {
            this.warning("Logging at DEBUG level without checking if DEBUG level is enabled: " + msg);
        }
        this.impl.debug(msg);
    }

    public void info(String msg) {
        if (!this.impl.isInfoEnabled()) {
            this.warning("Logging at INFO level without checking if INFO level is enabled: " + msg);
        }
        this.impl.info(msg);
    }

    public void warning(String msg) {
        this.impl.warn(msg);
    }

    public void warning(String msg, @Nullable Throwable e) {
        this.impl.warn(msg, e);
    }

    public void error(String msg) {
        this.impl.error(msg);
    }

    public void error(String msg, @Nullable Throwable e) {
        this.impl.error(msg, e);
    }

    public boolean isTraceEnabled() {
        return this.impl.isTraceEnabled();
    }

    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    @Nullable
    public String fileName() {
        return null;
    }

    public String toString() {
        return S.toString(Slf4jLogger.class, (Object)this);
    }
}

