/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2DatabaseType;
import org.apache.ignite.internal.processors.query.h2.H2SqlFieldMetadata;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.util.LocalDateTimeUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2Utils {
    static final int STRING_DEFAULT_PRECISION = Integer.MAX_VALUE;
    static final int DECIMAL_DEFAULT_PRECISION = 65535;
    static final int DECIMAL_DEFAULT_SCALE = Short.MAX_VALUE;
    public static final List<GridQueryFieldMetadata> UPDATE_RESULT_META = Collections.singletonList(new H2SqlFieldMetadata(null, null, "UPDATED", Long.class.getName(), -1, -1));
    private static final String SPATIAL_IDX_CLS = "org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex";
    private static final char ESC_CH = '\"';
    public static final GridCursor<H2Row> EMPTY_CURSOR = new GridCursor<H2Row>(){

        public boolean next() {
            return false;
        }

        public H2Row get() {
            return null;
        }
    };

    public static boolean equals(IndexColumn c1, IndexColumn c2) {
        return c1.column.getColumnId() == c2.column.getColumnId();
    }

    public static boolean containsColumn(List<IndexColumn> cols, IndexColumn col) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!H2Utils.equals(cols.get(i), col)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsKeyColumn(GridH2RowDescriptor desc, List<IndexColumn> cols) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!desc.isKeyColumn(cols.get((int)i).column.getColumnId())) continue;
            return true;
        }
        return false;
    }

    public static String tableCreateSql(H2TableDescriptor tbl) {
        GridQueryProperty keyProp = tbl.type().property("_KEY");
        GridQueryProperty valProp = tbl.type().property("_VAL");
        String keyType = H2Utils.dbTypeFromClass(tbl.type().keyClass(), keyProp == null ? -1 : keyProp.precision(), keyProp == null ? -1 : keyProp.scale());
        String valTypeStr = H2Utils.dbTypeFromClass(tbl.type().valueClass(), valProp == null ? -1 : valProp.precision(), valProp == null ? -1 : valProp.scale());
        SB sql = new SB();
        String keyValVisibility = tbl.type().fields().isEmpty() ? " VISIBLE" : " INVISIBLE";
        sql.a("CREATE TABLE ").a(tbl.fullTableName()).a(" (").a("_KEY").a(' ').a(keyType).a(keyValVisibility).a(" NOT NULL");
        sql.a(',').a("_VAL").a(' ').a(valTypeStr).a(keyValVisibility);
        for (Map.Entry e : tbl.type().fields().entrySet()) {
            GridQueryProperty prop = tbl.type().property((String)e.getKey());
            sql.a(',').a(H2Utils.withQuotes((String)e.getKey())).a(' ').a(H2Utils.dbTypeFromClass((Class)e.getValue(), prop.precision(), prop.scale())).a(prop.notNull() ? " NOT NULL" : "");
        }
        sql.a(')');
        return sql.toString();
    }

    public static String indexCreateSql(String fullTblName, GridH2IndexBase h2Idx, boolean ifNotExists) {
        boolean spatial = F.eq((Object)SPATIAL_IDX_CLS, (Object)((Object)((Object)h2Idx)).getClass().getName());
        GridStringBuilder sb = new SB("CREATE ").a(spatial ? "SPATIAL " : "").a("INDEX ").a(ifNotExists ? "IF NOT EXISTS " : "").a(H2Utils.withQuotes(h2Idx.getName())).a(" ON ").a(fullTblName).a(" (");
        sb.a(H2Utils.indexColumnsSql(h2Idx.getIndexColumns()));
        sb.a(')');
        return sb.toString();
    }

    public static String indexColumnsSql(IndexColumn[] idxCols) {
        SB sb = new SB();
        boolean first = true;
        for (IndexColumn col : idxCols) {
            if (first) {
                first = false;
            } else {
                sb.a(", ");
            }
            sb.a(H2Utils.withQuotes(col.columnName)).a(" ").a(col.sortType == 0 ? "ASC" : "DESC");
        }
        return sb.toString();
    }

    public static String indexDropSql(String schemaName, String idxName, boolean ifExists) {
        return "DROP INDEX " + (ifExists ? "IF EXISTS " : "") + H2Utils.withQuotes(schemaName) + '.' + H2Utils.withQuotes(idxName);
    }

    public static List<IndexColumn> treeIndexColumns(GridH2RowDescriptor desc, List<IndexColumn> cols, IndexColumn keyCol, IndexColumn affCol) {
        assert (keyCol != null);
        if (!H2Utils.containsKeyColumn(desc, cols)) {
            cols.add(keyCol);
        }
        if (affCol != null && !H2Utils.containsColumn(cols, affCol)) {
            cols.add(affCol);
        }
        return cols;
    }

    public static GridH2IndexBase createSpatialIndex(GridH2Table tbl, String idxName, IndexColumn[] cols) {
        try {
            Class<?> cls = Class.forName(SPATIAL_IDX_CLS);
            Constructor<?> ctor = cls.getConstructor(GridH2Table.class, String.class, Integer.TYPE, IndexColumn[].class);
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
            }
            int segments = tbl.rowDescriptor().cacheInfo().config().getQueryParallelism();
            return (GridH2IndexBase)((Object)ctor.newInstance(new Object[]{tbl, idxName, segments, cols}));
        }
        catch (Exception e) {
            throw new IgniteException("Failed to instantiate: org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex", (Throwable)e);
        }
    }

    public static String withQuotes(String str) {
        return '\"' + str + '\"';
    }

    public static List<GridQueryFieldMetadata> meta(ResultSetMetaData rsMeta) throws SQLException {
        ArrayList<GridQueryFieldMetadata> meta = new ArrayList<GridQueryFieldMetadata>(rsMeta.getColumnCount());
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            String schemaName = rsMeta.getSchemaName(i);
            String typeName = rsMeta.getTableName(i);
            String name = rsMeta.getColumnLabel(i);
            String type = rsMeta.getColumnClassName(i);
            int precision = rsMeta.getPrecision(i);
            int scale = rsMeta.getScale(i);
            if (type == null) {
                type = Void.class.getName();
            }
            meta.add(new H2SqlFieldMetadata(schemaName, typeName, name, type, precision, scale));
        }
        return meta;
    }

    public static List<JdbcParameterMeta> parametersMeta(ParameterMetaData h2ParamsMeta) throws IgniteCheckedException {
        try {
            int paramsSize = h2ParamsMeta.getParameterCount();
            if (paramsSize == 0) {
                return Collections.emptyList();
            }
            ArrayList<JdbcParameterMeta> params = new ArrayList<JdbcParameterMeta>(paramsSize);
            for (int i = 1; i <= paramsSize; ++i) {
                params.add(new JdbcParameterMeta(h2ParamsMeta, i));
            }
            return params;
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to get parameters metadata", (Throwable)e);
        }
    }

    public static Session session(Connection c) {
        return (Session)((JdbcConnection)c).getSession();
    }

    public static void setupConnection(Connection conn, boolean distributedJoins, boolean enforceJoinOrder) {
        H2Utils.setupConnection(conn, distributedJoins, enforceJoinOrder, false);
    }

    public static void setupConnection(Connection conn, boolean distributedJoins, boolean enforceJoinOrder, boolean lazy) {
        Session s = H2Utils.session(conn);
        s.setForceJoinOrder(enforceJoinOrder);
        s.setJoinBatchEnabled(distributedJoins);
        s.setLazyQueryExecution(lazy);
    }

    public static Object convert(Object val, IgniteH2Indexing idx, int type) throws IgniteCheckedException {
        if (val == null) {
            return null;
        }
        int objType = DataType.getTypeFromClass(val.getClass());
        if (objType == type) {
            return val;
        }
        Value h2Val = H2Utils.wrap(idx.objectContext(), val, objType);
        return h2Val.convertTo(type).getObject();
    }

    private H2Utils() {
    }

    public static QueryCursorImpl<List<?>> zeroCursor() {
        QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(0L)), null, false);
        resCur.fieldsMeta(UPDATE_RESULT_META);
        return resCur;
    }

    public static void addUniqueColumns(List<IndexColumn> dest, List<IndexColumn> src) {
        for (IndexColumn col : src) {
            if (H2Utils.containsColumn(dest, col)) continue;
            dest.add(col);
        }
    }

    public static boolean checkAndStartNotStartedCache(GridKernalContext ctx, GridH2Table tbl) {
        if (tbl != null && tbl.isCacheLazy()) {
            String cacheName = tbl.cacheInfo().config().getName();
            try {
                Boolean res = (Boolean)ctx.cache().dynamicStartCache(null, cacheName, null, false, true, true).get();
                return (Boolean)U.firstNotNull((Object[])new Boolean[]{res, Boolean.FALSE});
            }
            catch (IgniteCheckedException ex) {
                throw U.convertException((IgniteCheckedException)ex);
            }
        }
        return false;
    }

    public static Value wrap(CacheObjectValueContext coCtx, Object obj, int type) throws IgniteCheckedException {
        assert (obj != null);
        if (obj instanceof CacheObject) {
            CacheObject co = (CacheObject)obj;
            if (type == 19) {
                return new GridH2ValueCacheObject(co, coCtx);
            }
            obj = co.value(coCtx, false);
        }
        switch (type) {
            case 1: {
                return ValueBoolean.get((boolean)((Boolean)obj));
            }
            case 2: {
                return ValueByte.get((byte)((Byte)obj));
            }
            case 3: {
                return ValueShort.get((short)((Short)obj));
            }
            case 4: {
                return ValueInt.get((int)((Integer)obj));
            }
            case 8: {
                return ValueFloat.get((float)((Float)obj).floatValue());
            }
            case 5: {
                return ValueLong.get((long)((Long)obj));
            }
            case 7: {
                return ValueDouble.get((double)((Double)obj));
            }
            case 20: {
                UUID uuid = (UUID)obj;
                return ValueUuid.get((long)uuid.getMostSignificantBits(), (long)uuid.getLeastSignificantBits());
            }
            case 10: {
                if (LocalDateTimeUtils.LOCAL_DATE == obj.getClass()) {
                    return LocalDateTimeUtils.localDateToDateValue((Object)obj);
                }
                return ValueDate.get((java.sql.Date)((java.sql.Date)obj));
            }
            case 9: {
                if (LocalDateTimeUtils.LOCAL_TIME == obj.getClass()) {
                    return LocalDateTimeUtils.localTimeToTimeValue((Object)obj);
                }
                return ValueTime.get((Time)((Time)obj));
            }
            case 11: {
                if (obj instanceof Date && !(obj instanceof Timestamp)) {
                    obj = new Timestamp(((Date)obj).getTime());
                }
                if (LocalDateTimeUtils.LOCAL_DATE_TIME == obj.getClass()) {
                    return LocalDateTimeUtils.localDateTimeToValue((Object)obj);
                }
                return ValueTimestamp.get((Timestamp)((Timestamp)obj));
            }
            case 6: {
                return ValueDecimal.get((BigDecimal)((BigDecimal)obj));
            }
            case 13: {
                return ValueString.get((String)obj.toString());
            }
            case 12: {
                return ValueBytes.get((byte[])((byte[])obj));
            }
            case 19: {
                return ValueJavaObject.getNoCopy((Object)obj, null, null);
            }
            case 17: {
                Object[] arr = (Object[])obj;
                Value[] valArr = new Value[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    Object o = arr[i];
                    valArr[i] = o == null ? ValueNull.INSTANCE : H2Utils.wrap(coCtx, o, DataType.getTypeFromClass(o.getClass()));
                }
                return ValueArray.get((Value[])valArr);
            }
            case 22: {
                return ValueGeometry.getFromGeometry((Object)obj);
            }
        }
        throw new IgniteCheckedException("Failed to wrap value[type=" + type + ", value=" + obj + "]");
    }

    public static void validateTypeDescriptor(GridQueryTypeDescriptor type) throws IgniteCheckedException {
        assert (type != null);
        HashSet names = new HashSet();
        names.addAll(type.fields().keySet());
        if (names.size() < type.fields().size()) {
            throw new IgniteCheckedException("Found duplicated properties with the same name [keyType=" + type.keyClass().getName() + ", valueType=" + type.valueClass().getName() + "]");
        }
        String ptrn = "Name ''{0}'' is reserved and cannot be used as a field name [type=" + type.name() + "]";
        for (String name : names) {
            if (!name.equalsIgnoreCase("_KEY") && !name.equalsIgnoreCase("_VAL")) continue;
            throw new IgniteCheckedException(MessageFormat.format(ptrn, name));
        }
    }

    private static String dbTypeFromClass(Class<?> cls, int precision, int scale) {
        String dbType = H2DatabaseType.fromClass(cls).dBTypeAsString();
        if (precision != -1 && dbType.equalsIgnoreCase(H2DatabaseType.VARCHAR.dBTypeAsString())) {
            return dbType + "(" + precision + ")";
        }
        return dbType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String generateFieldsQueryString(String qry, String tableAlias, H2TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        String qry0 = qry;
        String t = tbl.fullTableName();
        String from = " ";
        String upper = (qry = qry.trim()).toUpperCase();
        if (upper.startsWith("SELECT")) {
            int star = (qry = qry.substring(6).trim()).indexOf(42);
            if (star == 0) {
                qry = qry.substring(1).trim();
            } else {
                if (star <= 0) throw new IgniteCheckedException("Only queries starting with 'SELECT *' and 'SELECT alias.*' are supported (rewrite your query or use SqlFieldsQuery instead): " + qry0);
                if (!F.eq((Object)Character.valueOf('.'), (Object)Character.valueOf(qry.charAt(star - 1)))) throw new IgniteCheckedException("Invalid query (missing alias before asterisk): " + qry0);
                t = qry.substring(0, star - 1);
                qry = qry.substring(star + 1).trim();
            }
            upper = qry.toUpperCase();
        }
        if (!upper.startsWith("FROM")) {
            from = " FROM " + t + (tableAlias != null ? " as " + tableAlias : "") + (upper.startsWith("WHERE") || upper.startsWith("ORDER") || upper.startsWith("LIMIT") ? " " : " WHERE ");
        }
        if (tableAlias == null) return "SELECT " + t + "." + "_KEY" + ", " + t + "." + "_VAL" + from + qry;
        t = tableAlias;
        return "SELECT " + t + "." + "_KEY" + ", " + t + "." + "_VAL" + from + qry;
    }

    public static GridH2RowMessage toRowMessage(Row row) {
        if (row == null) {
            return null;
        }
        int cols = row.getColumnCount();
        assert (cols > 0) : cols;
        ArrayList<GridH2ValueMessage> vals = new ArrayList<GridH2ValueMessage>(cols);
        for (int i = 0; i < cols; ++i) {
            try {
                vals.add(GridH2ValueMessageFactory.toMessage(row.getValue(i)));
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        GridH2RowMessage res = new GridH2RowMessage();
        res.values(vals);
        return res;
    }

    public static GridH2RetryException retryException(String msg) {
        return new GridH2RetryException(msg);
    }

    public static void bindParameters(PreparedStatement stmt, @Nullable Collection<Object> params) throws IgniteCheckedException {
        if (!F.isEmpty(params)) {
            int idx = 1;
            for (Object arg : params) {
                H2Utils.bindObject(stmt, idx++, arg);
            }
        }
    }

    private static void bindObject(PreparedStatement stmt, int idx, @Nullable Object obj) throws IgniteCheckedException {
        try {
            if (obj == null) {
                stmt.setNull(idx, 12);
            } else if (obj instanceof BigInteger) {
                stmt.setObject(idx, obj, 2000);
            } else if (obj instanceof BigDecimal) {
                stmt.setObject(idx, obj, 3);
            } else {
                stmt.setObject(idx, obj);
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to bind parameter [idx=" + idx + ", obj=" + obj + ", stmt=" + stmt + ']', (Throwable)e);
        }
    }

    public static <Z> void bubbleUp(Z[] arr, int off, Comparator<Z> cmp) {
        int last = arr.length - 1;
        for (int i = off; i < last && cmp.compare(arr[i], arr[i + 1]) > 0; ++i) {
            U.swap((Object[])arr, (int)i, (int)(i + 1));
        }
    }

    public static List<Integer> collectCacheIds(IgniteH2Indexing idx, @Nullable Integer mainCacheId, Collection<QueryTable> tbls) {
        LinkedHashSet<Integer> caches0 = new LinkedHashSet<Integer>();
        if (mainCacheId != null) {
            caches0.add(mainCacheId);
        }
        if (!F.isEmpty(tbls)) {
            for (QueryTable tblKey : tbls) {
                GridH2Table tbl = idx.schemaManager().dataTable(tblKey.schema(), tblKey.table());
                if (tbl == null) continue;
                H2Utils.checkAndStartNotStartedCache(idx.kernalContext(), tbl);
                caches0.add(tbl.cacheId());
            }
        }
        return caches0.isEmpty() ? Collections.emptyList() : new ArrayList(caches0);
    }

    public static boolean collectMvccEnabled(IgniteH2Indexing idx, List<Integer> cacheIds) {
        if (cacheIds.isEmpty()) {
            return false;
        }
        GridCacheSharedContext sharedCtx = idx.kernalContext().cache().context();
        GridCacheContext cctx0 = null;
        boolean mvccEnabled = false;
        for (int i = 0; i < cacheIds.size(); ++i) {
            Integer cacheId = cacheIds.get(i);
            GridCacheContext cctx = sharedCtx.cacheContext(cacheId.intValue());
            assert (cctx != null);
            if (i == 0) {
                mvccEnabled = cctx.mvccEnabled();
                cctx0 = cctx;
                continue;
            }
            if (cctx.mvccEnabled() == mvccEnabled) continue;
            MvccUtils.throwAtomicityModesMismatchException((CacheConfiguration)cctx0.config(), (CacheConfiguration)cctx.config());
        }
        return mvccEnabled;
    }

    public static void checkQuery(IgniteH2Indexing idx, List<Integer> cacheIds, Collection<QueryTable> tbls) {
        GridCacheSharedContext sharedCtx = idx.kernalContext().cache().context();
        int expectedParallelism = 0;
        for (int i = 0; i < cacheIds.size(); ++i) {
            Integer cacheId = cacheIds.get(i);
            GridCacheContext cctx = sharedCtx.cacheContext(cacheId.intValue());
            assert (cctx != null);
            if (!cctx.isPartitioned()) continue;
            if (expectedParallelism == 0) {
                expectedParallelism = cctx.config().getQueryParallelism();
                continue;
            }
            if (cctx.config().getQueryParallelism() == expectedParallelism) continue;
            throw new IllegalStateException("Using indexes with different parallelism levels in same query is forbidden.");
        }
        if (!F.isEmpty(tbls)) {
            for (QueryTable tbl : tbls) {
                if (!QueryUtils.SCHEMA_SYS.equals(tbl.schema())) continue;
                if (!F.isEmpty(cacheIds)) {
                    throw new IgniteSQLException("Normal tables and system views cannot be used in the same query.", 1002);
                }
                return;
            }
        }
    }

    @NotNull
    public static IndexColumn[] unwrapKeyColumns(GridH2Table tbl, IndexColumn[] idxCols) {
        ArrayList<IndexColumn> keyCols = new ArrayList<IndexColumn>();
        boolean isSql = tbl.rowDescriptor().tableDescriptor().sql();
        if (!isSql) {
            return idxCols;
        }
        GridQueryTypeDescriptor type = tbl.rowDescriptor().type();
        for (IndexColumn idxCol : idxCols) {
            if (idxCol.column.getColumnId() == 0) {
                if (QueryUtils.isSqlType((Class)type.keyClass())) {
                    int altKeyColId = tbl.rowDescriptor().getAlternativeColumnId(0);
                    IndexColumn idxKeyCol = new IndexColumn();
                    idxKeyCol.column = tbl.getColumn(altKeyColId);
                    idxKeyCol.columnName = idxKeyCol.column.getName();
                    idxKeyCol.sortType = idxCol.sortType;
                    keyCols.add(idxKeyCol);
                    continue;
                }
                boolean added = false;
                for (String propName : type.fields().keySet()) {
                    GridQueryProperty prop = type.property(propName);
                    if (!prop.key()) continue;
                    added = true;
                    Column col = tbl.getColumn(propName);
                    keyCols.add(tbl.indexColumn(col.getColumnId(), 0));
                }
                if (added) continue;
                keyCols.add(idxCol);
                continue;
            }
            keyCols.add(idxCol);
        }
        return keyCols.toArray(new IndexColumn[0]);
    }
}

