/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.Prepared;
import org.h2.engine.Session;

public class H2QueryInfo {
    private final QueryType type;
    private final long beginTs;
    private final String schema;
    private final String sql;
    private final boolean enforceJoinOrder;
    private final boolean distributedJoin;
    private final boolean lazy;
    private final Prepared stmt;

    public H2QueryInfo(QueryType type, PreparedStatement stmt, String sql) {
        try {
            assert (stmt != null);
            this.type = type;
            this.sql = sql;
            this.beginTs = U.currentTimeMillis();
            this.schema = stmt.getConnection().getSchema();
            Session s = H2Utils.session(stmt.getConnection());
            this.enforceJoinOrder = s.isForceJoinOrder();
            this.distributedJoin = s.isJoinBatchEnabled();
            this.lazy = s.isLazyQueryExecution();
            this.stmt = GridSqlQueryParser.prepared(stmt);
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Cannot collect query info", 1, (Throwable)e);
        }
    }

    protected void printInfo(StringBuilder msg) {
    }

    public long time() {
        return U.currentTimeMillis() - this.beginTs;
    }

    public void printLogMessage(IgniteLogger log, String msg) {
        StringBuilder msgSb = new StringBuilder(msg + " [");
        msgSb.append("time=").append(this.time()).append("ms").append(", type=").append((Object)this.type).append(", distributedJoin=").append(this.distributedJoin).append(", enforceJoinOrder=").append(this.enforceJoinOrder).append(", lazy=").append(this.lazy).append(", schema=").append(this.schema);
        this.printInfo(msgSb);
        msgSb.append(", sql='").append(this.sql);
        if (this.type != QueryType.REDUCE) {
            msgSb.append("', plan=").append(this.stmt.getPlanSQL());
        }
        msgSb.append(']');
        LT.warn((IgniteLogger)log, (String)msgSb.toString());
    }

    public static enum QueryType {
        LOCAL,
        MAP,
        REDUCE;

    }
}

