/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class H2ConnectionWrapper
implements AutoCloseable {
    private static final int STATEMENT_CACHE_SIZE = 256;
    private final Connection conn;
    private volatile String schema;
    private volatile H2StatementCache statementCache;

    H2ConnectionWrapper(Connection conn) {
        this.conn = conn;
        this.initStatementCache();
    }

    public String schema() {
        return this.schema;
    }

    public void schema(@Nullable String schema) {
        this.schema = schema;
    }

    public Connection connection(@Nullable String schema) {
        if (schema != null && !F.eq((Object)this.schema, (Object)schema)) {
            try {
                this.conn.setSchema(schema);
                this.schema = schema;
            }
            catch (SQLException e) {
                throw new IgniteSQLException("Failed to set schema for DB connection for thread [schema=" + schema + "]", (Throwable)e);
            }
        }
        return this.conn;
    }

    public Connection connection() {
        return this.conn;
    }

    public H2StatementCache statementCache() {
        return this.statementCache;
    }

    public void clearStatementCache() {
        this.initStatementCache();
    }

    public int statementCacheSize() {
        return this.statementCache == null ? 0 : this.statementCache.size();
    }

    private void initStatementCache() {
        this.statementCache = new H2StatementCache(256);
    }

    public String toString() {
        return S.toString(H2ConnectionWrapper.class, (Object)this);
    }

    @Override
    public void close() {
        U.closeQuiet((AutoCloseable)this.conn);
    }
}

