/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.RunningQueryManager;
import org.apache.ignite.internal.util.typedef.X;

public class RegisteredQueryCursor<T>
extends QueryCursorImpl<T> {
    private final AtomicBoolean unregistered = new AtomicBoolean(false);
    private RunningQueryManager runningQryMgr;
    private Long qryId;
    private boolean failed;

    public RegisteredQueryCursor(Iterable<T> iterExec, GridQueryCancel cancel, RunningQueryManager runningQryMgr, Long qryId) {
        super(iterExec, cancel);
        assert (runningQryMgr != null);
        assert (qryId != null);
        this.runningQryMgr = runningQryMgr;
        this.qryId = qryId;
    }

    protected Iterator<T> iter() {
        try {
            return super.iter();
        }
        catch (Exception e) {
            this.failed = true;
            if (X.cause((Throwable)e, QueryCancelledException.class) != null) {
                this.unregisterQuery();
            }
            throw e;
        }
    }

    public void close() {
        this.unregisterQuery();
        super.close();
    }

    private void unregisterQuery() {
        if (this.unregistered.compareAndSet(false, true)) {
            this.runningQryMgr.unregister(this.qryId, this.failed);
        }
    }
}

