/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.h2.value.Value;

public class GridResultPage {
    private final UUID src;
    protected final GridQueryNextPageResponse res;
    private final Collection<Value[]> rows;
    private final boolean last;

    public GridResultPage(UUID src, GridQueryNextPageResponse res, boolean last) {
        assert (src != null);
        this.src = src;
        this.res = res;
        this.last = last;
        if (last) assert (res == null) : "The last page must be dummy.";
        this.rows = res == null ? Collections.emptySet() : GridMapQueryExecutor.unmarshallRows(res.rows());
    }

    public boolean isLast() {
        return this.last;
    }

    public Collection<Value[]> rows() {
        return this.rows;
    }

    public UUID source() {
        return this.src;
    }

    public GridQueryNextPageResponse response() {
        return this.res;
    }

    public void fetchNextPage() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(GridResultPage.class, (Object)this);
    }
}

