/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public enum GridSqlOperationType {
    CONCAT(2, new BiExpressionSqlGenerator("||")),
    PLUS(2, new BiExpressionSqlGenerator("+")),
    MINUS(2, new BiExpressionSqlGenerator("-")),
    MULTIPLY(2, new BiExpressionSqlGenerator("*")),
    DIVIDE(2, new BiExpressionSqlGenerator("/")),
    MODULUS(2, new BiExpressionSqlGenerator("%")),
    NEGATE(1, new PrefixSqlGenerator("-")),
    EQUAL(2, new BiExpressionSqlGenerator("=")),
    EQUAL_NULL_SAFE(2, new BiExpressionSqlGenerator("IS")),
    BIGGER_EQUAL(2, new BiExpressionSqlGenerator(">=")),
    BIGGER(2, new BiExpressionSqlGenerator(">")),
    SMALLER_EQUAL(2, new BiExpressionSqlGenerator("<=")),
    SMALLER(2, new BiExpressionSqlGenerator("<")),
    NOT_EQUAL(2, new BiExpressionSqlGenerator("<>")),
    NOT_EQUAL_NULL_SAFE(2, new BiExpressionSqlGenerator("IS NOT")),
    SPATIAL_INTERSECTS(2, new IntersectsSqlGenerator()),
    IS_NULL(1, new SuffixSqlGenerator("IS NULL")),
    IS_NOT_NULL(1, new SuffixSqlGenerator("IS NOT NULL")),
    NOT(1, new PrefixSqlGenerator("NOT")),
    AND(2, new BiExpressionSqlGenerator("AND")),
    OR(2, new BiExpressionSqlGenerator("OR")),
    REGEXP(2, new BiExpressionSqlGenerator("REGEXP")),
    LIKE(2, new BiExpressionSqlGenerator("LIKE")),
    IN(-1, new ConditionInSqlGenerator());

    private final SqlGenerator sqlGenerator;
    private final int childrenCnt;

    private GridSqlOperationType(int childrenCnt, SqlGenerator sqlGenerator) {
        this.childrenCnt = childrenCnt;
        this.sqlGenerator = sqlGenerator;
    }

    public String toSql(GridSqlOperation operation) {
        return this.sqlGenerator.getSql(operation);
    }

    public int childrenCount() {
        return this.childrenCnt;
    }

    private static class ConditionInSqlGenerator
    implements SqlGenerator {
        private ConditionInSqlGenerator() {
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            StatementBuilder buff = new StatementBuilder("(");
            buff.append(operation.child(0).getSQL()).append(" IN(");
            assert (operation.size() > 1);
            if (operation.size() == 2) {
                String child = operation.child(1).getSQL();
                buff.append(' ').append(StringUtils.unEnclose((String)child)).append(' ');
            } else {
                for (int i = 1; i < operation.size(); ++i) {
                    buff.appendExceptFirst(", ");
                    buff.append(operation.child(i).getSQL());
                }
            }
            return buff.append("))").toString();
        }
    }

    private static class SuffixSqlGenerator
    implements SqlGenerator {
        private final String text;

        private SuffixSqlGenerator(String text) {
            this.text = text;
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            assert (operation.opType().childrenCnt == 1);
            return '(' + operation.child().getSQL() + ' ' + this.text + ')';
        }
    }

    private static class PrefixSqlGenerator
    implements SqlGenerator {
        private final String text;

        private PrefixSqlGenerator(String text) {
            this.text = text;
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            assert (operation.opType().childrenCnt == 1);
            return '(' + this.text + ' ' + operation.child().getSQL() + ')';
        }
    }

    private static class IntersectsSqlGenerator
    implements SqlGenerator {
        private IntersectsSqlGenerator() {
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            assert (operation.opType().childrenCnt == 2);
            return "(INTERSECTS(" + operation.child(0) + ", " + operation.child(1) + "))";
        }
    }

    private static class BiExpressionSqlGenerator
    implements SqlGenerator {
        private final String delim;

        private BiExpressionSqlGenerator(String delim) {
            this.delim = delim;
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            assert (operation.opType().childrenCnt == 2);
            return '(' + operation.child(0).getSQL() + " " + this.delim + " " + operation.child(1).getSQL() + ')';
        }
    }

    private static interface SqlGenerator {
        public String getSql(GridSqlOperation var1);
    }
}

