/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.Iterator;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2AbstractKeyValueRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.lang.GridFilteredIterator;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.jetbrains.annotations.Nullable;

public abstract class GridH2IndexBase
extends BaseIndex {
    protected static final ThreadLocal<IndexingQueryFilter> filters = new ThreadLocal();
    protected final int keyCol;
    protected final int valCol;

    protected GridH2IndexBase(int keyCol, int valCol) {
        this.keyCol = keyCol;
        this.valCol = valCol;
    }

    public static void setFiltersForThread(IndexingQueryFilter fs) {
        if (fs == null) {
            filters.remove();
        } else {
            filters.set(fs);
        }
    }

    public GridH2IndexBase rebuild() throws InterruptedException {
        return this;
    }

    public abstract GridH2Row put(GridH2Row var1);

    public abstract GridH2Row remove(SearchRow var1);

    public Object takeSnapshot(@Nullable Object s) {
        return s;
    }

    public void releaseSnapshot() {
    }

    protected Iterator<GridH2Row> filter(Iterator<GridH2Row> iter) {
        IgniteBiPredicate p = null;
        IndexingQueryFilter f = filters.get();
        if (f != null) {
            String spaceName = ((GridH2Table)this.getTable()).spaceName();
            p = f.forSpace(spaceName);
        }
        return new FilteringIterator(iter, U.currentTimeMillis(), p);
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public void remove(Session ses) {
        throw DbException.getUnsupportedException((String)"remove index");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean needRebuild() {
        return false;
    }

    protected class FilteringIterator
    extends GridFilteredIterator<GridH2Row> {
        private final IgniteBiPredicate<Object, Object> fltr;
        private final long time;

        protected FilteringIterator(Iterator<GridH2Row> iter, long time, IgniteBiPredicate<Object, Object> fltr) {
            super(iter);
            this.time = time;
            this.fltr = fltr;
        }

        protected boolean accept(GridH2Row row) {
            if (row instanceof GridH2AbstractKeyValueRow && ((GridH2AbstractKeyValueRow)row).expirationTime() <= this.time) {
                return false;
            }
            if (this.fltr == null) {
                return true;
            }
            Object key = row.getValue(GridH2IndexBase.this.keyCol).getObject();
            Object val = row.getValue(GridH2IndexBase.this.valCol).getObject();
            assert (key != null);
            assert (val != null);
            return this.fltr.apply(key, val);
        }
    }
}

