/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCache;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.GridCacheSwapEntry;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResultAdapter;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexType;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.GridH2ResultSetIterator;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2AbstractKeyValueRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOffheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOnheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeGuard;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.Driver;
import org.h2.api.JavaObjectSerializer;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.index.Index;
import org.h2.index.SpatialIndex;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.DbException;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.server.Service;
import org.h2.server.web.WebServer;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.tools.Server;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class IgniteH2Indexing
implements GridQueryIndexing {
    private static final String DB_OPTIONS = ";LOCK_MODE=3;MULTI_THREADED=1;DB_CLOSE_ON_EXIT=FALSE;DEFAULT_LOCK_TIMEOUT=10000;FUNCTIONS_IN_SCHEMA=true;OPTIMIZE_REUSE_RESULTS=0;QUERY_CACHE_SIZE=0;RECOMPILE_ALWAYS=1;MAX_OPERATION_MEMORY=0";
    public static final String KEY_FIELD_NAME = "_key";
    public static final String VAL_FIELD_NAME = "_val";
    private static final Field COMMAND_FIELD;
    @LoggerResource
    private IgniteLogger log;
    private UUID nodeId;
    private Marshaller marshaller;
    private final ConcurrentMap<String, Schema> schemas = new ConcurrentHashMap8();
    private String dbUrl = "jdbc:h2:mem:";
    private final Collection<Connection> conns = Collections.synchronizedCollection(new ArrayList());
    private GridMapQueryExecutor mapQryExec;
    private GridReduceQueryExecutor rdcQryExec;
    private final ThreadLocal<ConnectionWrapper> connCache = new ThreadLocal<ConnectionWrapper>(){

        @Override
        @Nullable
        public ConnectionWrapper get() {
            ConnectionWrapper c = (ConnectionWrapper)super.get();
            boolean reconnect = true;
            try {
                reconnect = c == null || c.connection().isClosed();
            }
            catch (SQLException e) {
                U.warn((IgniteLogger)IgniteH2Indexing.this.log, (Object)"Failed to check connection status.", (Object)e);
            }
            if (reconnect) {
                c = this.initialValue();
                this.set(c);
            }
            return c;
        }

        @Override
        @Nullable
        protected ConnectionWrapper initialValue() {
            Connection c;
            try {
                c = DriverManager.getConnection(IgniteH2Indexing.this.dbUrl);
            }
            catch (SQLException e) {
                throw new IgniteException("Failed to initialize DB connection: " + IgniteH2Indexing.this.dbUrl, (Throwable)e);
            }
            IgniteH2Indexing.this.conns.add(c);
            return new ConnectionWrapper(c);
        }
    };
    private volatile GridKernalContext ctx;

    public Connection connectionForSpace(@Nullable String space) {
        try {
            return this.connectionForThread(IgniteH2Indexing.schema(space));
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private Connection connectionForThread(@Nullable String schema) throws IgniteCheckedException {
        ConnectionWrapper c = this.connCache.get();
        if (c == null) {
            throw new IgniteCheckedException("Failed to get DB connection for thread (check log for details).");
        }
        if (schema != null && !F.eq((Object)c.schema(), (Object)schema)) {
            Statement stmt = null;
            try {
                stmt = c.connection().createStatement();
                stmt.executeUpdate("SET SCHEMA \"" + schema + '\"');
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set schema: " + schema);
                }
                c.schema(schema);
            }
            catch (SQLException e) {
                throw new IgniteCheckedException("Failed to set schema for DB connection for thread [schema=" + schema + "]", (Throwable)e);
            }
            finally {
                U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
            }
        }
        return c.connection();
    }

    private void createSchema(String schema) throws IgniteCheckedException {
        this.executeStatement("INFORMATION_SCHEMA", "CREATE SCHEMA IF NOT EXISTS \"" + schema + '\"');
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created H2 schema for index database: " + schema);
        }
    }

    private void dropSchema(String schema) throws IgniteCheckedException {
        this.executeStatement("INFORMATION_SCHEMA", "DROP SCHEMA IF EXISTS \"" + schema + '\"');
        if (this.log.isDebugEnabled()) {
            this.log.debug("Dropped H2 schema for index database: " + schema);
        }
    }

    public void executeStatement(String schema, String sql) throws IgniteCheckedException {
        Statement stmt = null;
        try {
            Connection c = this.connectionForThread(schema);
            stmt = c.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            try {
                this.onSqlException();
                throw new IgniteCheckedException("Failed to execute statement: " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                U.close(stmt, (IgniteLogger)this.log);
                throw throwable;
            }
        }
        U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
    }

    private void removeKey(@Nullable String spaceName, Object key, TableDescriptor tblToUpdate) throws IgniteCheckedException {
        try {
            Collection<TableDescriptor> tbls = this.tables(IgniteH2Indexing.schema(spaceName));
            for (TableDescriptor tbl : tbls) {
                if (tbl == tblToUpdate || !tbl.type().keyClass().isAssignableFrom(key.getClass()) || !tbl.tbl.update(key, null, 0L, true)) continue;
                if (tbl.luceneIdx != null) {
                    tbl.luceneIdx.remove(key);
                }
                return;
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to remove key: " + key, (Throwable)e);
        }
    }

    private void bindObject(PreparedStatement stmt, int idx, @Nullable Object obj) throws IgniteCheckedException {
        try {
            if (obj == null) {
                stmt.setNull(idx, 12);
            } else {
                stmt.setObject(idx, obj);
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to bind parameter [idx=" + idx + ", obj=" + obj + ", stmt=" + stmt + ']', (Throwable)e);
        }
    }

    private void onSqlException() {
        Connection conn = this.connCache.get().connection();
        this.connCache.set(null);
        if (conn != null) {
            this.conns.remove(conn);
            U.close((AutoCloseable)conn, (IgniteLogger)this.log);
        }
    }

    public void store(@Nullable String spaceName, GridQueryTypeDescriptor type, Object k, Object v, byte[] ver, long expirationTime) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        this.removeKey(spaceName, k, tbl);
        if (tbl == null) {
            return;
        }
        if (expirationTime == 0L) {
            expirationTime = Long.MAX_VALUE;
        }
        tbl.tbl.update(k, v, expirationTime, false);
        if (tbl.luceneIdx != null) {
            tbl.luceneIdx.store(k, v, ver, expirationTime);
        }
    }

    public void remove(@Nullable String spaceName, Object key, Object val) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing key from cache query index [locId=" + this.nodeId + ", key=" + key + ']');
        }
        for (TableDescriptor tbl : this.tables(IgniteH2Indexing.schema(spaceName))) {
            if (!tbl.type().keyClass().isAssignableFrom(key.getClass()) || val != null && !tbl.type().valueClass().isAssignableFrom(val.getClass()) || !tbl.tbl.update(key, val, 0L, true)) continue;
            if (tbl.luceneIdx != null) {
                tbl.luceneIdx.remove(key);
            }
            return;
        }
    }

    public void onSwap(@Nullable String spaceName, Object key) throws IgniteCheckedException {
        Schema schema = (Schema)this.schemas.get(IgniteH2Indexing.schema(spaceName));
        if (schema == null) {
            return;
        }
        for (TableDescriptor tbl : schema.tbls.values()) {
            if (!tbl.type().keyClass().isAssignableFrom(key.getClass())) continue;
            try {
                if (!tbl.tbl.onSwap(key)) continue;
                return;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        }
    }

    public void onUnswap(@Nullable String spaceName, Object key, Object val, byte[] valBytes) throws IgniteCheckedException {
        assert (val != null);
        for (TableDescriptor tbl : this.tables(IgniteH2Indexing.schema(spaceName))) {
            if (!tbl.type().keyClass().isAssignableFrom(key.getClass()) || !tbl.type().valueClass().isAssignableFrom(val.getClass())) continue;
            try {
                if (!tbl.tbl.onUnswap(key, val)) continue;
                return;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        }
    }

    private void removeTable(TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing query index table: " + tbl.fullTableName());
        }
        Connection c = this.connectionForThread(tbl.schema());
        Statement stmt = null;
        try {
            stmt = c.createStatement();
            String sql = "DROP TABLE IF EXISTS " + tbl.fullTableName();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dropping database index table with SQL: " + sql);
            }
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException("Failed to drop database index table [type=" + tbl.type().name() + ", table=" + tbl.fullTableName() + "]", (Throwable)e);
        }
        finally {
            U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
        }
        tbl.tbl.close();
        if (tbl.luceneIdx != null) {
            U.closeQuiet((AutoCloseable)tbl.luceneIdx);
        }
        tbl.schema.tbls.remove(tbl.name());
    }

    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryText(@Nullable String spaceName, String qry, GridQueryTypeDescriptor type, IndexingQueryFilter filters) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl != null && tbl.luceneIdx != null) {
            return tbl.luceneIdx.query(qry, filters);
        }
        return new GridEmptyCloseableIterator();
    }

    public void unregisterType(@Nullable String spaceName, GridQueryTypeDescriptor type) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl != null) {
            this.removeTable(tbl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridQueryFieldsResult queryFields(@Nullable String spaceName, String qry, @Nullable Collection<Object> params, IndexingQueryFilter filters) throws IgniteCheckedException {
        this.setFilters(filters);
        try {
            Connection conn = this.connectionForThread(IgniteH2Indexing.schema(spaceName));
            ResultSet rs = this.executeSqlQueryWithTimer(spaceName, conn, qry, params);
            List<GridQueryFieldMetadata> meta = null;
            if (rs != null) {
                try {
                    meta = IgniteH2Indexing.meta(rs.getMetaData());
                }
                catch (SQLException e) {
                    throw new IgniteSpiException("Failed to get meta data.", (Throwable)e);
                }
            }
            GridQueryFieldsResultAdapter gridQueryFieldsResultAdapter = new GridQueryFieldsResultAdapter(meta, (GridCloseableIterator)new FieldsIterator(rs));
            return gridQueryFieldsResultAdapter;
        }
        finally {
            this.setFilters(null);
        }
    }

    private static List<GridQueryFieldMetadata> meta(ResultSetMetaData rsMeta) throws SQLException {
        ArrayList<GridQueryFieldMetadata> meta = new ArrayList<GridQueryFieldMetadata>(rsMeta.getColumnCount());
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            String schemaName = rsMeta.getSchemaName(i);
            String typeName = rsMeta.getTableName(i);
            String name = rsMeta.getColumnLabel(i);
            String type = rsMeta.getColumnClassName(i);
            meta.add(new SqlFieldMetadata(schemaName, typeName, name, type));
        }
        return meta;
    }

    private static int commandType(PreparedStatement stmt) {
        try {
            return ((CommandInterface)COMMAND_FIELD.get(stmt)).getCommandType();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private ResultSet executeSqlQuery(Connection conn, String sql, Collection<Object> params) throws IgniteCheckedException {
        PreparedStatement stmt;
        try {
            stmt = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to parse SQL query: " + sql, (Throwable)e);
        }
        switch (IgniteH2Indexing.commandType(stmt)) {
            case 21: 
            case 57: 
            case 60: 
            case 66: {
                break;
            }
            default: {
                throw new IgniteCheckedException("Failed to execute non-query SQL statement: " + sql);
            }
        }
        this.bindParameters(stmt, params);
        try {
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to execute SQL query.", (Throwable)e);
        }
    }

    public ResultSet executeSqlQueryWithTimer(String space, Connection conn, String sql, @Nullable Collection<Object> params) throws IgniteCheckedException {
        long start = U.currentTimeMillis();
        try {
            ResultSet rs = this.executeSqlQuery(conn, sql, params);
            long time = U.currentTimeMillis() - start;
            long longQryExecTimeout = ((Schema)this.schemas.get(IgniteH2Indexing.schema(space))).ccfg.getLongQueryWarningTimeout();
            if (time > longQryExecTimeout) {
                String msg = "Query execution is too long (" + time + " ms): " + sql;
                ResultSet plan = this.executeSqlQuery(conn, "EXPLAIN " + sql, params);
                plan.next();
                String longMsg = "Query execution is too long [time=" + time + " ms, sql='" + sql + '\'' + ", plan=" + U.nl() + plan.getString(1) + U.nl() + ", parameters=" + params + "]";
                LT.warn((IgniteLogger)this.log, null, (String)longMsg, (String)msg);
            }
            return rs;
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private ResultSet executeQuery(String space, String qry, @Nullable Collection<Object> params, TableDescriptor tbl) throws IgniteCheckedException {
        Connection conn = this.connectionForThread(tbl.schema());
        String sql = this.generateQuery(qry, tbl);
        return this.executeSqlQueryWithTimer(space, conn, sql, params);
    }

    public void bindParameters(PreparedStatement stmt, @Nullable Collection<Object> params) throws IgniteCheckedException {
        if (!F.isEmpty(params)) {
            int idx = 1;
            for (Object arg : params) {
                this.bindObject(stmt, idx++, arg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> query(@Nullable String spaceName, String qry, @Nullable Collection<Object> params, GridQueryTypeDescriptor type, IndexingQueryFilter filters) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            throw new CacheException("Failed to find SQL table for type: " + type.name());
        }
        this.setFilters(filters);
        try {
            ResultSet rs = this.executeQuery(spaceName, qry, params, tbl);
            KeyValIterator keyValIterator = new KeyValIterator(rs);
            return keyValIterator;
        }
        finally {
            this.setFilters(null);
        }
    }

    public QueryCursor<List<?>> queryTwoStep(GridCacheContext<?, ?> cctx, GridCacheTwoStepQuery qry) {
        return this.rdcQryExec.query(cctx, qry);
    }

    public <K, V> QueryCursor<Cache.Entry<K, V>> queryTwoStep(GridCacheContext<?, ?> cctx, SqlQuery qry) {
        String sql;
        String space;
        String type = qry.getType();
        TableDescriptor tblDesc = this.tableDescriptor(type, space = cctx.name());
        if (tblDesc == null) {
            throw new CacheException("Failed to find SQL table for type: " + type);
        }
        try {
            sql = this.generateQuery(qry.getSql(), tblDesc);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        SqlFieldsQuery fqry = new SqlFieldsQuery(sql);
        fqry.setArgs(qry.getArgs());
        fqry.setPageSize(qry.getPageSize());
        final QueryCursor<List<?>> res = this.queryTwoStep(cctx, fqry);
        final Iterator iter0 = res.iterator();
        Iterator iter = new Iterator<Cache.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return iter0.hasNext();
            }

            @Override
            public Cache.Entry<K, V> next() {
                List l = (List)iter0.next();
                return new CacheEntryImpl(l.get(0), l.get(1));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new QueryCursorImpl<Cache.Entry<K, V>>(iter){

            public void close() {
                res.close();
            }
        };
    }

    public QueryCursor<List<?>> queryTwoStep(GridCacheContext<?, ?> cctx, SqlFieldsQuery qry) {
        List<GridQueryFieldMetadata> meta;
        GridCacheTwoStepQuery twoStepQry;
        PreparedStatement stmt;
        String space = cctx.name();
        String sqlQry = qry.getSql();
        Connection c = this.connectionForSpace(space);
        try {
            stmt = c.prepareStatement(sqlQry);
        }
        catch (SQLException e) {
            throw new CacheException("Failed to parse query: " + sqlQry, (Throwable)e);
        }
        try {
            twoStepQry = GridSqlQuerySplitter.split((JdbcPreparedStatement)stmt, qry.getArgs());
            meta = IgniteH2Indexing.meta(stmt.getMetaData());
        }
        catch (SQLException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parsed query: `" + sqlQry + "` into two step query: " + twoStepQry);
        }
        twoStepQry.pageSize(qry.getPageSize());
        QueryCursorImpl cursor = (QueryCursorImpl)this.queryTwoStep(cctx, twoStepQry);
        cursor.fieldsMeta(meta);
        return cursor;
    }

    public void setFilters(@Nullable IndexingQueryFilter filters) {
        GridH2IndexBase.setFiltersForThread(filters);
    }

    private String generateQuery(String qry, TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        String t = tbl.fullTableName();
        String from = " ";
        String upper = qry.trim().toUpperCase();
        if (!upper.startsWith("FROM")) {
            from = " FROM " + t + (upper.startsWith("WHERE") || upper.startsWith("ORDER") || upper.startsWith("LIMIT") ? " " : " WHERE ");
        }
        qry = "SELECT " + t + "." + KEY_FIELD_NAME + ", " + t + "." + VAL_FIELD_NAME + from + qry;
        return qry;
    }

    public boolean registerType(@Nullable String spaceName, GridQueryTypeDescriptor type) throws IgniteCheckedException {
        if (!this.validateTypeDescriptor(type)) {
            return false;
        }
        String schemaName = IgniteH2Indexing.schema(spaceName);
        Schema schema = (Schema)this.schemas.get(schemaName);
        TableDescriptor tbl = new TableDescriptor(schema, type);
        try {
            Connection conn = this.connectionForThread(schemaName);
            this.createTable(schema, tbl, conn);
            schema.add(tbl);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException("Failed to register query type: " + type, (Throwable)e);
        }
        return true;
    }

    private boolean validateTypeDescriptor(GridQueryTypeDescriptor type) throws IgniteCheckedException {
        assert (type != null);
        HashSet names = new HashSet();
        names.addAll(type.fields().keySet());
        if (names.size() < type.fields().size()) {
            throw new IgniteCheckedException("Found duplicated properties with the same name [keyType=" + type.keyClass().getName() + ", valueType=" + type.valueClass().getName() + "]");
        }
        String ptrn = "Name ''{0}'' is reserved and cannot be used as a field name [class=" + type + "]";
        for (String name : names) {
            if (!name.equals(KEY_FIELD_NAME) && !name.equals(VAL_FIELD_NAME)) continue;
            throw new IgniteCheckedException(MessageFormat.format(ptrn, name));
        }
        return true;
    }

    private static String escapeName(String name, boolean escapeAll) {
        if (escapeAll) {
            return "\"" + name + "\"";
        }
        SB sb = null;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '_' || ch == '\"' && (i == 0 || i == name.length() - 1) || ch == '-') continue;
            assert (ch == '$' || ch == '.');
            if (sb == null) {
                sb = new SB();
            }
            sb.a(name.substring(sb.length(), i));
            sb.a('_');
        }
        if (sb == null) {
            return name;
        }
        sb.a(name.substring(sb.length(), name.length()));
        return sb.toString();
    }

    private void createTable(Schema schema, TableDescriptor tbl, Connection conn) throws SQLException {
        assert (schema != null);
        assert (tbl != null);
        boolean escapeAll = schema.escapeAll();
        String keyType = this.dbTypeFromClass(tbl.type().keyClass());
        String valTypeStr = this.dbTypeFromClass(tbl.type().valueClass());
        SB sql = new SB();
        sql.a("CREATE TABLE ").a(tbl.fullTableName()).a(" (").a(KEY_FIELD_NAME).a(' ').a(keyType).a(" NOT NULL");
        sql.a(',').a(VAL_FIELD_NAME).a(' ').a(valTypeStr);
        for (Map.Entry e : tbl.type().fields().entrySet()) {
            sql.a(',').a(IgniteH2Indexing.escapeName((String)e.getKey(), escapeAll)).a(' ').a(this.dbTypeFromClass((Class)e.getValue()));
        }
        sql.a(')');
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating DB table with SQL: " + sql);
        }
        RowDescriptor desc = new RowDescriptor(tbl.type(), schema);
        GridH2Table.Engine.createTable(conn, sql.toString(), desc, tbl, tbl.schema.spaceName);
    }

    private String dbTypeFromClass(Class<?> cls) {
        return DBTypeEnum.fromClass(cls).dBTypeAsString();
    }

    @Nullable
    private TableDescriptor tableDescriptor(@Nullable String spaceName, GridQueryTypeDescriptor type) {
        return this.tableDescriptor(type.name(), spaceName);
    }

    @Nullable
    private TableDescriptor tableDescriptor(String type, @Nullable String space) {
        Schema s = (Schema)this.schemas.get(IgniteH2Indexing.schema(space));
        if (s == null) {
            return null;
        }
        return (TableDescriptor)s.tbls.get(type);
    }

    private Collection<TableDescriptor> tables(String schema) {
        Schema s = (Schema)this.schemas.get(schema);
        if (s == null) {
            return Collections.emptySet();
        }
        return s.tbls.values();
    }

    private static String schema(@Nullable String space) {
        if (space == null) {
            return "";
        }
        return space;
    }

    public void rebuildIndexes(@Nullable String spaceName, GridQueryTypeDescriptor type) {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            return;
        }
        if (tbl.schema.offheap != null) {
            throw new UnsupportedOperationException("Index rebuilding is not supported when off-heap memory is used");
        }
        tbl.tbl.rebuildIndexes();
    }

    public long size(@Nullable String spaceName, GridQueryTypeDescriptor type, IndexingQueryFilter filters) throws IgniteCheckedException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            return -1L;
        }
        IgniteSpiCloseableIterator iter = this.queryFields(spaceName, "SELECT COUNT(*) FROM " + tbl.fullTableName(), null, null).iterator();
        return ((Number)((List)iter.next()).get(0)).longValue();
    }

    public GridMapQueryExecutor mapQueryExecutor() {
        return this.mapQryExec;
    }

    public GridReduceQueryExecutor reduceQueryExecutor() {
        return this.rdcQryExec;
    }

    public void start(GridKernalContext ctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting cache query index...");
        }
        System.setProperty("h2.serializeJavaObject", "false");
        if (SysProperties.serializeJavaObject) {
            U.warn((IgniteLogger)this.log, (Object)"Serialization of Java objects in H2 was enabled.");
            SysProperties.serializeJavaObject = false;
        }
        if (Utils.serializer != null) {
            U.warn((IgniteLogger)this.log, (Object)"Custom H2 serialization is already configured, will override.");
        }
        Utils.serializer = this.h2Serializer();
        String dbName = (ctx != null ? ctx.localNodeId() : UUID.randomUUID()).toString();
        this.dbUrl = "jdbc:h2:mem:" + dbName + DB_OPTIONS;
        Driver.load();
        try {
            if (IgniteSystemProperties.getString((String)"IGNITE_H2_DEBUG_CONSOLE") != null) {
                Connection c = DriverManager.getConnection(this.dbUrl);
                WebServer webSrv = new WebServer();
                Server web = new Server((Service)webSrv, new String[]{"-webPort", "0"});
                web.start();
                String url = webSrv.addSession(c);
                try {
                    Server.openBrowser((String)url);
                }
                catch (Exception e) {
                    U.warn((IgniteLogger)this.log, (Object)("Failed to open browser: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        if (ctx == null) {
            this.marshaller = new JdkMarshaller();
        } else {
            this.ctx = ctx;
            this.nodeId = ctx.localNodeId();
            this.marshaller = ctx.config().getMarshaller();
            this.mapQryExec = new GridMapQueryExecutor();
            this.rdcQryExec = new GridReduceQueryExecutor();
            this.mapQryExec.start(ctx, this);
            this.rdcQryExec.start(ctx, this);
        }
    }

    protected JavaObjectSerializer h2Serializer() {
        return new JavaObjectSerializer(){

            public byte[] serialize(Object obj) throws Exception {
                return IgniteH2Indexing.this.marshaller.marshal(obj);
            }

            public Object deserialize(byte[] bytes) throws Exception {
                return IgniteH2Indexing.this.marshaller.unmarshal(bytes, null);
            }
        };
    }

    private void createSqlFunctions(String schema, Class<?>[] clss) throws IgniteCheckedException {
        if (F.isEmpty((Object[])clss)) {
            return;
        }
        for (Class<?> cls : clss) {
            for (Method m : cls.getDeclaredMethods()) {
                QuerySqlFunction ann = m.getAnnotation(QuerySqlFunction.class);
                if (ann == null) continue;
                int modifiers = m.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                    throw new IgniteCheckedException("Method " + m.getName() + " must be public static.");
                }
                String alias = ann.alias().isEmpty() ? m.getName() : ann.alias();
                String clause = "CREATE ALIAS IF NOT EXISTS " + alias + (ann.deterministic() ? " DETERMINISTIC FOR \"" : " FOR \"") + cls.getName() + '.' + m.getName() + '\"';
                this.executeStatement(schema, clause);
            }
        }
    }

    public void stop() throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping cache query index...");
        }
        for (Schema schema : this.schemas.values()) {
            for (TableDescriptor desc : schema.tbls.values()) {
                desc.tbl.close();
                if (desc.luceneIdx == null) continue;
                U.closeQuiet((AutoCloseable)desc.luceneIdx);
            }
        }
        this.executeStatement("INFORMATION_SCHEMA", "SHUTDOWN");
        for (Connection c : this.conns) {
            U.close((AutoCloseable)c, (IgniteLogger)this.log);
        }
        this.conns.clear();
        this.schemas.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cache query index stopped.");
        }
    }

    public void registerCache(CacheConfiguration<?, ?> ccfg) throws IgniteCheckedException {
        String schema = IgniteH2Indexing.schema(ccfg.getName());
        if (this.schemas.putIfAbsent(schema, new Schema(ccfg.getName(), (GridUnsafeMemory)(ccfg.getOffHeapMaxMemory() >= 0L || ccfg.getMemoryMode() == CacheMemoryMode.OFFHEAP_TIERED ? new GridUnsafeMemory(0L) : null), ccfg)) != null) {
            throw new IgniteCheckedException("Cache already registered: " + ccfg.getName());
        }
        this.createSchema(schema);
        this.createSqlFunctions(schema, ccfg.getSqlFunctionClasses());
    }

    public void unregisterCache(CacheConfiguration<?, ?> ccfg) {
        String schema = IgniteH2Indexing.schema(ccfg.getName());
        Schema rmv = (Schema)this.schemas.remove(schema);
        if (rmv != null) {
            try {
                this.dropSchema(schema);
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)("Failed to drop schema on cache stop (will ignore): " + ccfg.getName()), (Throwable)e);
            }
        }
    }

    public IndexingQueryFilter backupFilter() {
        return new IndexingQueryFilter(){

            @Nullable
            public <K, V> IgniteBiPredicate<K, V> forSpace(String spaceName) {
                final GridCacheAdapter cache = IgniteH2Indexing.this.ctx.cache().internalCache(spaceName);
                if (cache.context().isReplicated() || cache.configuration().getBackups() == 0) {
                    return null;
                }
                return new IgniteBiPredicate<K, V>(){

                    public boolean apply(K k, V v) {
                        return cache.context().affinity().primary(IgniteH2Indexing.this.ctx.discovery().localNode(), k, AffinityTopologyVersion.NONE);
                    }
                };
            }
        };
    }

    static {
        try {
            COMMAND_FIELD = JdbcPreparedStatement.class.getDeclaredField("command");
            COMMAND_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }

    private class RowDescriptor
    implements GridH2RowDescriptor {
        private final GridQueryTypeDescriptor type;
        private final String[] fields;
        private final int[] fieldTypes;
        private final int keyType;
        private final int valType;
        private final Schema schema;
        private final GridUnsafeGuard guard;

        RowDescriptor(GridQueryTypeDescriptor type, Schema schema) {
            assert (type != null);
            assert (schema != null);
            this.type = type;
            this.schema = schema;
            this.guard = schema.offheap == null ? null : new GridUnsafeGuard();
            LinkedHashMap allFields = new LinkedHashMap();
            allFields.putAll(type.fields());
            this.fields = allFields.keySet().toArray(new String[allFields.size()]);
            this.fieldTypes = new int[this.fields.length];
            Class[] classes = allFields.values().toArray(new Class[this.fields.length]);
            for (int i = 0; i < this.fieldTypes.length; ++i) {
                this.fieldTypes[i] = DataType.getTypeFromClass((Class)classes[i]);
            }
            this.keyType = DataType.getTypeFromClass((Class)type.keyClass());
            this.valType = DataType.getTypeFromClass((Class)type.valueClass());
        }

        @Override
        public GridUnsafeGuard guard() {
            return this.guard;
        }

        @Override
        public void cache(GridH2KeyValueRowOffheap row) {
            long ptr = row.pointer();
            assert (ptr > 0L) : ptr;
            this.schema.rowCache.put(ptr, (Object)row);
        }

        @Override
        public void uncache(long ptr) {
            this.schema.rowCache.remove(ptr);
        }

        @Override
        public GridUnsafeMemory memory() {
            return this.schema.offheap;
        }

        @Override
        public IgniteH2Indexing owner() {
            return IgniteH2Indexing.this;
        }

        @Override
        public GridH2Row createRow(Object key, @Nullable Object val, long expirationTime) throws IgniteCheckedException {
            try {
                if (val == null) {
                    return new GridH2Row(GridH2AbstractKeyValueRow.wrap(key, this.keyType), null);
                }
                return this.schema.offheap == null ? new GridH2KeyValueRowOnheap(this, key, this.keyType, val, this.valType, expirationTime) : new GridH2KeyValueRowOffheap(this, key, this.keyType, val, this.valType, expirationTime);
            }
            catch (ClassCastException e) {
                throw new IgniteCheckedException("Failed to convert key to SQL type. Please make sure that you always store each value type with the same key type or configure key type as common super class for all actual keys for this value type.", (Throwable)e);
            }
        }

        @Override
        public Object readFromSwap(Object key) throws IgniteCheckedException {
            GridCacheSwapEntry e;
            GridCache cache = IgniteH2Indexing.this.ctx.cache().cache(this.schema.spaceName);
            GridCacheContext cctx = ((GridCacheProxyImpl)cache).context();
            if (cctx.isNear()) {
                cctx = cctx.near().dht().context();
            }
            if ((e = cctx.swap().read(cctx.toCacheKeyObject(key), true, true)) == null) {
                return null;
            }
            CacheObject v = e.value();
            assert (v != null) : "swap must unmarshall it for us";
            return v.value(cctx.cacheObjectContext(), false);
        }

        @Override
        public int valueType() {
            return this.valType;
        }

        @Override
        public int fieldsCount() {
            return this.fields.length;
        }

        @Override
        public int fieldType(int col) {
            return this.fieldTypes[col];
        }

        @Override
        public Object columnValue(Object key, Object val, int col) {
            try {
                return this.type.value(this.fields[col], key, val);
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }

        public GridH2KeyValueRowOffheap createPointer(long ptr) {
            GridH2KeyValueRowOffheap row = (GridH2KeyValueRowOffheap)this.schema.rowCache.get(ptr);
            if (row != null) {
                assert (row.pointer() == ptr) : ptr + " " + row.pointer();
                return row;
            }
            return new GridH2KeyValueRowOffheap(this, ptr);
        }
    }

    private static class Schema {
        private static final long serialVersionUID = 0L;
        private final String spaceName;
        private final GridUnsafeMemory offheap;
        private final ConcurrentMap<String, TableDescriptor> tbls = new ConcurrentHashMap8();
        private final CacheLongKeyLIRS<GridH2KeyValueRowOffheap> rowCache;
        private final CacheConfiguration<?, ?> ccfg;

        private Schema(@Nullable String spaceName, GridUnsafeMemory offheap, CacheConfiguration<?, ?> ccfg) {
            this.spaceName = spaceName;
            this.offheap = offheap;
            this.ccfg = ccfg;
            this.rowCache = offheap != null ? new CacheLongKeyLIRS((long)ccfg.getSqlOnheapRowCacheSize(), 1, 128, 256) : null;
        }

        public void add(TableDescriptor tbl) {
            if (this.tbls.putIfAbsent(tbl.name(), tbl) != null) {
                throw new IllegalStateException("Table already registered: " + tbl.name());
            }
        }

        public boolean escapeAll() {
            return this.ccfg.isSqlEscapeAll();
        }
    }

    private static class SqlFieldMetadata
    implements GridQueryFieldMetadata {
        private static final long serialVersionUID = 0L;
        private String schemaName;
        private String typeName;
        private String name;
        private String type;

        public SqlFieldMetadata() {
        }

        SqlFieldMetadata(@Nullable String schemaName, @Nullable String typeName, String name, String type) {
            assert (name != null);
            assert (type != null);
            this.schemaName = schemaName;
            this.typeName = typeName;
            this.name = name;
            this.type = type;
        }

        public String schemaName() {
            return this.schemaName;
        }

        public String typeName() {
            return this.typeName;
        }

        public String fieldName() {
            return this.name;
        }

        public String fieldTypeName() {
            return this.type;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.schemaName);
            U.writeString((DataOutput)out, (String)this.typeName);
            U.writeString((DataOutput)out, (String)this.name);
            U.writeString((DataOutput)out, (String)this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.schemaName = U.readString((DataInput)in);
            this.typeName = U.readString((DataInput)in);
            this.name = U.readString((DataInput)in);
            this.type = U.readString((DataInput)in);
        }

        public String toString() {
            return S.toString(SqlFieldMetadata.class, (Object)this);
        }
    }

    private static class KeyValIterator<K, V>
    extends GridH2ResultSetIterator<IgniteBiTuple<K, V>> {
        private static final long serialVersionUID = 0L;

        protected KeyValIterator(ResultSet data) throws IgniteCheckedException {
            super(data);
        }

        @Override
        protected IgniteBiTuple<K, V> createRow() {
            Object key = this.row[0];
            Object val = this.row[1];
            return new IgniteBiTuple(key, val);
        }
    }

    private static class FieldsIterator
    extends GridH2ResultSetIterator<List<?>> {
        private static final long serialVersionUID = 0L;

        protected FieldsIterator(ResultSet data) throws IgniteCheckedException {
            super(data);
        }

        @Override
        protected List<?> createRow() {
            ArrayList res = new ArrayList(this.row.length);
            Collections.addAll(res, this.row);
            return res;
        }
    }

    private class TableDescriptor
    implements GridH2Table.IndexesFactory {
        private final String fullTblName;
        private final GridQueryTypeDescriptor type;
        private final Schema schema;
        private GridH2Table tbl;
        private GridLuceneIndex luceneIdx;

        TableDescriptor(Schema schema, GridQueryTypeDescriptor type) {
            this.type = type;
            this.schema = schema;
            this.fullTblName = '\"' + IgniteH2Indexing.schema(schema.spaceName) + "\"." + IgniteH2Indexing.escapeName(type.name(), schema.escapeAll());
        }

        public String schema() {
            return IgniteH2Indexing.schema(this.schema.spaceName);
        }

        String fullTableName() {
            return this.fullTblName;
        }

        String name() {
            return this.type.name();
        }

        GridQueryTypeDescriptor type() {
            return this.type;
        }

        public String toString() {
            return S.toString(TableDescriptor.class, (Object)this);
        }

        @Override
        public ArrayList<Index> createIndexes(GridH2Table tbl) {
            this.tbl = tbl;
            ArrayList<Index> idxs = new ArrayList<Index>();
            idxs.add((Index)new GridH2TreeIndex("_key_PK", tbl, true, 0, 1, tbl.indexColumn(0, 0)));
            if (this.type().valueClass() == String.class) {
                try {
                    this.luceneIdx = new GridLuceneIndex(IgniteH2Indexing.this.ctx, IgniteH2Indexing.this.marshaller, this.schema.offheap, this.schema.spaceName, this.type, true);
                }
                catch (IgniteCheckedException e1) {
                    throw new IgniteException((Throwable)e1);
                }
            }
            for (Map.Entry e : this.type.indexes().entrySet()) {
                String name = (String)e.getKey();
                GridQueryIndexDescriptor idx = (GridQueryIndexDescriptor)e.getValue();
                if (idx.type() == GridQueryIndexType.FULLTEXT) {
                    try {
                        this.luceneIdx = new GridLuceneIndex(IgniteH2Indexing.this.ctx, IgniteH2Indexing.this.marshaller, this.schema.offheap, this.schema.spaceName, this.type, true);
                        continue;
                    }
                    catch (IgniteCheckedException e1) {
                        throw new IgniteException((Throwable)e1);
                    }
                }
                IndexColumn[] cols = new IndexColumn[idx.fields().size()];
                int i = 0;
                boolean escapeAll = this.schema.escapeAll();
                for (String field : idx.fields()) {
                    String fieldName = escapeAll ? field : IgniteH2Indexing.escapeName(field, false).toUpperCase();
                    Column col = tbl.getColumn(fieldName);
                    cols[i++] = tbl.indexColumn(col.getColumnId(), idx.descending(field) ? 1 : 0);
                }
                if (idx.type() == GridQueryIndexType.SORTED) {
                    idxs.add((Index)new GridH2TreeIndex(name, tbl, false, 0, 1, cols));
                    continue;
                }
                if (idx.type() == GridQueryIndexType.GEO_SPATIAL) {
                    idxs.add((Index)this.createH2SpatialIndex((Table)tbl, name, cols, 0, 1));
                    continue;
                }
                throw new IllegalStateException();
            }
            return idxs;
        }

        private SpatialIndex createH2SpatialIndex(Table tbl, String idxName, IndexColumn[] cols, int keyCol, int valCol) {
            String className = "org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex";
            try {
                Class<?> cls = Class.forName(className);
                Constructor<?> ctor = cls.getConstructor(Table.class, String.class, IndexColumn[].class, Integer.TYPE, Integer.TYPE);
                if (!ctor.isAccessible()) {
                    ctor.setAccessible(true);
                }
                return (SpatialIndex)ctor.newInstance(tbl, idxName, cols, keyCol, valCol);
            }
            catch (Exception e) {
                throw new IgniteException("Failed to instantiate: " + className, (Throwable)e);
            }
        }
    }

    private static enum DBTypeEnum {
        INT("INT"),
        BOOL("BOOL"),
        TINYINT("TINYINT"),
        SMALLINT("SMALLINT"),
        BIGINT("BIGINT"),
        DECIMAL("DECIMAL"),
        DOUBLE("DOUBLE"),
        REAL("REAL"),
        TIME("TIME"),
        TIMESTAMP("TIMESTAMP"),
        DATE("DATE"),
        VARCHAR("VARCHAR"),
        CHAR("CHAR"),
        BINARY("BINARY"),
        UUID("UUID"),
        ARRAY("ARRAY"),
        GEOMETRY("GEOMETRY"),
        OTHER("OTHER");

        private static final Map<Class<?>, DBTypeEnum> map;
        private final String dbType;

        private DBTypeEnum(String dbType) {
            this.dbType = dbType;
        }

        public static DBTypeEnum fromClass(Class<?> cls) {
            DBTypeEnum res = map.get(cls);
            if (res != null) {
                return res;
            }
            if (DataType.isGeometryClass(cls)) {
                return GEOMETRY;
            }
            return cls.isArray() && !cls.getComponentType().isPrimitive() ? ARRAY : OTHER;
        }

        public String dBTypeAsString() {
            return this.dbType;
        }

        public String toString() {
            return S.toString(DBTypeEnum.class, (Object)((Object)this));
        }

        static {
            map = new HashMap();
            map.put(Integer.TYPE, INT);
            map.put(Integer.class, INT);
            map.put(Boolean.TYPE, BOOL);
            map.put(Boolean.class, BOOL);
            map.put(Byte.TYPE, TINYINT);
            map.put(Byte.class, TINYINT);
            map.put(Short.TYPE, SMALLINT);
            map.put(Short.class, SMALLINT);
            map.put(Long.TYPE, BIGINT);
            map.put(Long.class, BIGINT);
            map.put(BigDecimal.class, DECIMAL);
            map.put(Double.TYPE, DOUBLE);
            map.put(Double.class, DOUBLE);
            map.put(Float.TYPE, REAL);
            map.put(Float.class, REAL);
            map.put(Time.class, TIME);
            map.put(Timestamp.class, TIMESTAMP);
            map.put(Date.class, TIMESTAMP);
            map.put(java.sql.Date.class, DATE);
            map.put(Character.TYPE, CHAR);
            map.put(Character.class, CHAR);
            map.put(String.class, VARCHAR);
            map.put(UUID.class, UUID);
            map.put(byte[].class, BINARY);
        }
    }

    private static class ConnectionWrapper {
        private Connection conn;
        private volatile String schema;

        ConnectionWrapper(Connection conn) {
            this.conn = conn;
        }

        public String schema() {
            return this.schema;
        }

        public void schema(@Nullable String schema) {
            this.schema = schema;
        }

        public Connection connection() {
            return this.conn;
        }

        public String toString() {
            return S.toString(ConnectionWrapper.class, (Object)this);
        }
    }
}

