/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.nio.file.Path;
import java.util.Objects;
import org.apache.ignite.deployment.DeploymentUnit;

public class DisposableDeploymentUnit {
    private final DeploymentUnit unit;
    private final Path path;
    private final Runnable release;

    public DisposableDeploymentUnit(DeploymentUnit unit, Path path, Runnable release) {
        this.unit = unit;
        this.path = path;
        this.release = release;
    }

    public DeploymentUnit unit() {
        return this.unit;
    }

    public Path path() {
        return this.path;
    }

    public void release() {
        this.release.run();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisposableDeploymentUnit that = (DisposableDeploymentUnit)o;
        return Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        return Objects.hash(this.unit);
    }

    public String toString() {
        return "DisposableDeploymentUnit{unit=" + String.valueOf(this.unit) + ", path=" + String.valueOf(this.path) + "}";
    }
}

