/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage.serialization;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataOutput;

public class CatalogObjectDataOutput
extends IgniteUnsafeDataOutput {
    private static final int INITIAL_BUFFER_CAPACITY = 256;
    private final CatalogEntrySerializerProvider serializers;

    public CatalogObjectDataOutput(CatalogEntrySerializerProvider serializers) {
        super(256);
        this.serializers = serializers;
    }

    public void writeEntry(MarshallableEntry entry) throws IOException {
        int typeId = entry.typeId();
        int entryVersion = this.serializers.latestSerializerVersion(typeId);
        this.writeEntryHeader(entry, entryVersion);
        this.serializers.get(entryVersion, typeId).writeTo(entry, this);
    }

    public <T extends MarshallableEntry> void writeEntryList(List<T> entries) throws IOException {
        this.writeVarInt(entries.size());
        for (MarshallableEntry entry : entries) {
            int typeId = entry.typeId();
            int version = this.serializers.latestSerializerVersion(typeId);
            this.writeEntryHeader(entry, version);
            this.serializers.get(version, typeId).writeTo(entry, this);
        }
    }

    public <T extends MarshallableEntry> void writeCompactEntryList(List<T> entries) throws IOException {
        if (entries.isEmpty()) {
            this.writeVarInt(0L);
            return;
        }
        this.writeVarInt(entries.size());
        int typeId = ((MarshallableEntry)entries.get(0)).typeId();
        int version = this.serializers.latestSerializerVersion(typeId);
        this.writeEntryHeader((MarshallableEntry)entries.get(0), version);
        CatalogObjectSerializer<MarshallableEntry> serializer = this.serializers.get(version, typeId);
        for (MarshallableEntry entry : entries) {
            assert (entry.typeId() == typeId) : "Entry type do not match";
            serializer.writeTo(entry, this);
        }
    }

    public <T> void writeObjectCollection(ElementWriter<T> writer, Collection<T> list) throws IOException {
        this.writeVarInt(list.size());
        for (T element : list) {
            writer.write(this, element);
        }
    }

    private void writeEntryHeader(MarshallableEntry entry, int entryVersion) throws IOException {
        int typeId = entry.typeId();
        this.writeShort(typeId);
        this.writeVarInt(entryVersion);
    }

    @FunctionalInterface
    public static interface ElementWriter<T> {
        public void write(CatalogObjectDataOutput var1, T var2) throws IOException;
    }
}

