/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.storage.DropIndexEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;

public class DropIndexEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class DropIndexEntrySerializerV2
    implements CatalogObjectSerializer<DropIndexEntry> {
        DropIndexEntrySerializerV2() {
        }

        @Override
        public DropIndexEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int indexId = input.readVarIntAsInt();
            return new DropIndexEntry(indexId);
        }

        @Override
        public void writeTo(DropIndexEntry entry, CatalogObjectDataOutput out) throws IOException {
            out.writeVarInt(entry.indexId());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class DropIndexEntrySerializerV1
    implements CatalogObjectSerializer<DropIndexEntry> {
        DropIndexEntrySerializerV1() {
        }

        @Override
        public DropIndexEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int indexId = input.readVarIntAsInt();
            return new DropIndexEntry(indexId);
        }

        @Override
        public void writeTo(DropIndexEntry entry, CatalogObjectDataOutput out) throws IOException {
            out.writeVarInt(entry.indexId());
        }
    }
}

