/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.StoppingIndexEventParameters;
import org.apache.ignite.internal.catalog.storage.AbstractChangeIndexStatusEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class DropIndexEntry
extends AbstractChangeIndexStatusEntry
implements Fireable {
    public static final CatalogObjectSerializer<DropIndexEntry> SERIALIZER = new DropIndexEntrySerializer();

    public DropIndexEntry(int indexId) {
        super(indexId, CatalogIndexStatus.STOPPING);
    }

    public int indexId() {
        return this.indexId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_INDEX.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.INDEX_STOPPING;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new StoppingIndexEventParameters(causalityToken, catalogVersion, this.indexId);
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class DropIndexEntrySerializer
    implements CatalogObjectSerializer<DropIndexEntry> {
        private DropIndexEntrySerializer() {
        }

        @Override
        public DropIndexEntry readFrom(IgniteDataInput input) throws IOException {
            int indexId = input.readVarIntAsInt();
            return new DropIndexEntry(indexId);
        }

        @Override
        public void writeTo(DropIndexEntry entry, IgniteDataOutput out) throws IOException {
            out.writeVarInt((long)entry.indexId());
        }
    }
}

