/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.DistributionZoneCantBeDroppedValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractZoneCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.DropZoneCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.DropZoneEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class DropZoneCommand
extends AbstractZoneCommand {
    private final boolean ifExists;

    public static DropZoneCommandBuilder builder() {
        return new Builder();
    }

    private DropZoneCommand(String zoneName, boolean ifExists) throws CatalogValidationException {
        super(zoneName);
        this.ifExists = ifExists;
    }

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        CatalogZoneDescriptor zone = CatalogUtils.zoneOrThrow(catalog, this.zoneName);
        CatalogZoneDescriptor defaultZone = catalog.defaultZone();
        if (defaultZone != null && zone.id() == defaultZone.id()) {
            throw new DistributionZoneCantBeDroppedValidationException("Default distribution zone can't be dropped: zoneName={}", this.zoneName);
        }
        catalog.schemas().stream().flatMap(s -> Arrays.stream(s.tables())).filter(t -> t.zoneId() == zone.id()).findAny().ifPresent(t -> {
            throw new DistributionZoneCantBeDroppedValidationException("Distribution zone '{}' is assigned to the table '{}'", zone.name(), t.name());
        });
        return List.of(new DropZoneEntry(zone.id()));
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    private static class Builder
    implements DropZoneCommandBuilder {
        private String zoneName;
        private boolean ifExists;

        private Builder() {
        }

        @Override
        public DropZoneCommandBuilder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public DropZoneCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new DropZoneCommand(this.zoneName, this.ifExists);
        }
    }
}

