/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.DropTableCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.DropTableEntry;
import org.apache.ignite.internal.catalog.storage.RemoveIndexEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class DropTableCommand
extends AbstractTableCommand {
    public static DropTableCommandBuilder builder() {
        return new Builder();
    }

    private DropTableCommand(String schemaName, String tableName, boolean ifExists) throws CatalogValidationException {
        super(schemaName, tableName, ifExists);
    }

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(schema, this.tableName);
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();
        Arrays.stream(schema.indexes()).filter(index -> index.tableId() == table.id()).forEach(index -> updateEntries.add(new RemoveIndexEntry(index.id())));
        updateEntries.add(new DropTableEntry(table.id()));
        return updateEntries;
    }

    private static class Builder
    implements DropTableCommandBuilder {
        private String schemaName;
        private String tableName;
        private boolean ifExists;

        private Builder() {
        }

        @Override
        public DropTableCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public DropTableCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public DropTableCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifExists = ifTableExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new DropTableCommand(this.schemaName, this.tableName, this.ifExists);
        }
    }
}

