/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;

public abstract class AbstractIndexCommand
implements CatalogCommand {
    protected final String schemaName;
    protected final String indexName;

    AbstractIndexCommand(String schemaName, String indexName) throws CatalogValidationException {
        this.schemaName = schemaName;
        this.indexName = indexName;
        this.validate();
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String indexName() {
        return this.indexName;
    }

    private void validate() {
        CatalogParamsValidationUtils.validateIdentifier(this.schemaName, "Name of the schema");
        CatalogParamsValidationUtils.validateIdentifier(this.indexName, "Name of the index");
        CatalogParamsValidationUtils.ensureNonSystemSchemaUsed(this.schemaName);
    }
}

