/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcSchemaVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;

class OrcToIcebergVisitor
extends OrcSchemaVisitor<Optional<Types.NestedField>> {
    OrcToIcebergVisitor() {
    }

    @Override
    public Optional<Types.NestedField> record(TypeDescription record, List<String> names, List<Optional<Types.NestedField>> fields) {
        boolean isOptional = ORCSchemaUtil.isOptional(record);
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(record);
        if (!icebergIdOpt.isPresent() || fields.stream().noneMatch(Optional::isPresent)) {
            return Optional.empty();
        }
        Types.StructType structType = Types.StructType.of(fields.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        return Optional.of(Types.NestedField.builder().withId(icebergIdOpt.get().intValue()).isOptional(isOptional).withName(this.currentFieldName()).ofType((Type)structType).build());
    }

    @Override
    public Optional<Types.NestedField> list(TypeDescription array, Optional<Types.NestedField> element) {
        boolean isOptional = ORCSchemaUtil.isOptional(array);
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(array);
        if (!icebergIdOpt.isPresent() || !element.isPresent()) {
            return Optional.empty();
        }
        Types.NestedField foundElement = element.get();
        Types.ListType listTypeWithElem = ORCSchemaUtil.isOptional((TypeDescription)array.getChildren().get(0)) ? Types.ListType.ofOptional((int)foundElement.fieldId(), (Type)foundElement.type()) : Types.ListType.ofRequired((int)foundElement.fieldId(), (Type)foundElement.type());
        return Optional.of(Types.NestedField.builder().withId(icebergIdOpt.get().intValue()).isOptional(isOptional).withName(this.currentFieldName()).ofType((Type)listTypeWithElem).build());
    }

    @Override
    public Optional<Types.NestedField> map(TypeDescription map, Optional<Types.NestedField> key, Optional<Types.NestedField> value) {
        boolean isOptional = ORCSchemaUtil.isOptional(map);
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(map);
        if (!(icebergIdOpt.isPresent() && key.isPresent() && value.isPresent())) {
            return Optional.empty();
        }
        Types.NestedField foundKey = key.get();
        Types.NestedField foundValue = value.get();
        Types.MapType mapTypeWithKV = ORCSchemaUtil.isOptional((TypeDescription)map.getChildren().get(1)) ? Types.MapType.ofOptional((int)foundKey.fieldId(), (int)foundValue.fieldId(), (Type)foundKey.type(), (Type)foundValue.type()) : Types.MapType.ofRequired((int)foundKey.fieldId(), (int)foundValue.fieldId(), (Type)foundKey.type(), (Type)foundValue.type());
        return Optional.of(Types.NestedField.builder().withId(icebergIdOpt.get().intValue()).isOptional(isOptional).withName(this.currentFieldName()).ofType((Type)mapTypeWithKV).build());
    }

    @Override
    public Optional<Types.NestedField> variant(TypeDescription variant, Optional<Types.NestedField> metadata, Optional<Types.NestedField> value) {
        boolean isOptional = ORCSchemaUtil.isOptional(variant);
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(variant);
        return icebergIdOpt.map(fieldId -> Types.NestedField.builder().withId(fieldId.intValue()).isOptional(isOptional).ofType((Type)Types.VariantType.get()).withName(this.currentFieldName()).build());
    }

    @Override
    public Optional<Types.NestedField> primitive(TypeDescription primitive) {
        boolean isOptional = ORCSchemaUtil.isOptional(primitive);
        Optional<Integer> icebergIdOpt = ORCSchemaUtil.icebergID(primitive);
        if (!icebergIdOpt.isPresent()) {
            return Optional.empty();
        }
        Types.NestedField.Builder builder = Types.NestedField.builder().withId(icebergIdOpt.get().intValue()).isOptional(isOptional).withName(this.currentFieldName());
        switch (primitive.getCategory()) {
            case BOOLEAN: {
                builder.ofType((Type)Types.BooleanType.get());
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                builder.ofType((Type)Types.IntegerType.get());
                break;
            }
            case LONG: {
                OrcToIcebergVisitor.convertLong(primitive, builder);
                break;
            }
            case FLOAT: {
                builder.ofType((Type)Types.FloatType.get());
                break;
            }
            case DOUBLE: {
                builder.ofType((Type)Types.DoubleType.get());
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                builder.ofType((Type)Types.StringType.get());
                break;
            }
            case BINARY: {
                OrcToIcebergVisitor.convertBinary(primitive, builder);
                break;
            }
            case DATE: {
                builder.ofType((Type)Types.DateType.get());
                break;
            }
            case TIMESTAMP: {
                String unit = primitive.getAttributeValue("iceberg.timestamp-unit");
                if (unit == null || "MICROS".equalsIgnoreCase(unit)) {
                    builder.ofType((Type)Types.TimestampType.withoutZone());
                    break;
                }
                if (unit.equalsIgnoreCase("NANOS")) {
                    builder.ofType((Type)Types.TimestampNanoType.withoutZone());
                    break;
                }
                throw new IllegalStateException("Invalid Timestamp type unit: %s" + unit);
            }
            case TIMESTAMP_INSTANT: {
                String tsUnit = primitive.getAttributeValue("iceberg.timestamp-unit");
                if (tsUnit == null || "MICROS".equalsIgnoreCase(tsUnit)) {
                    builder.ofType((Type)Types.TimestampType.withZone());
                    break;
                }
                if (tsUnit.equalsIgnoreCase("NANOS")) {
                    builder.ofType((Type)Types.TimestampNanoType.withZone());
                    break;
                }
                throw new IllegalStateException("Invalid Timestamp type unit: %s" + tsUnit);
            }
            case DECIMAL: {
                builder.ofType((Type)Types.DecimalType.of((int)primitive.getPrecision(), (int)primitive.getScale()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't handle " + String.valueOf(primitive));
            }
        }
        return Optional.of(builder.build());
    }

    private static void convertLong(TypeDescription primitive, Types.NestedField.Builder builder) {
        String longAttributeValue = primitive.getAttributeValue("iceberg.long-type");
        ORCSchemaUtil.LongType longType = longAttributeValue == null ? ORCSchemaUtil.LongType.LONG : ORCSchemaUtil.LongType.valueOf(longAttributeValue);
        switch (longType) {
            case TIME: {
                builder.ofType((Type)Types.TimeType.get());
                break;
            }
            case LONG: {
                builder.ofType((Type)Types.LongType.get());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Long type found in ORC type attribute");
            }
        }
    }

    private static void convertBinary(TypeDescription binary, Types.NestedField.Builder builder) {
        String binaryAttributeValue = binary.getAttributeValue("iceberg.binary-type");
        ORCSchemaUtil.BinaryType binaryType = binaryAttributeValue == null ? ORCSchemaUtil.BinaryType.BINARY : ORCSchemaUtil.BinaryType.valueOf(binaryAttributeValue);
        switch (binaryType) {
            case UUID: {
                builder.ofType((Type)Types.UUIDType.get());
                break;
            }
            case FIXED: {
                int fixedLength = Integer.parseInt(binary.getAttributeValue("iceberg.length"));
                builder.ofType((Type)Types.FixedType.ofLength((int)fixedLength));
                break;
            }
            case BINARY: {
                builder.ofType((Type)Types.BinaryType.get());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Binary type found in ORC type attribute");
            }
        }
    }
}

