/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.orc.TypeDescription;

public abstract class OrcSchemaVisitor<T> {
    private final Deque<String> fieldNames = Lists.newLinkedList();

    public static <T> List<T> visitSchema(TypeDescription schema, OrcSchemaVisitor<T> visitor) {
        Preconditions.checkArgument((schema.getId() == 0 ? 1 : 0) != 0, (Object)"TypeDescription must be root schema.");
        List fields = schema.getChildren();
        List names = schema.getFieldNames();
        return OrcSchemaVisitor.visitFields(fields, names, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T visit(TypeDescription schema, OrcSchemaVisitor<T> visitor) {
        switch (schema.getCategory()) {
            case STRUCT: {
                String structType = schema.getAttributeValue("iceberg.struct-type");
                if ("VARIANT".equalsIgnoreCase(structType)) {
                    return OrcSchemaVisitor.visitVariant(schema, visitor);
                }
                return OrcSchemaVisitor.visitRecord(schema, visitor);
            }
            case UNION: {
                throw new UnsupportedOperationException("Cannot handle " + String.valueOf(schema));
            }
            case LIST: {
                T elementResult;
                TypeDescription element = (TypeDescription)schema.getChildren().get(0);
                visitor.beforeElementField(element);
                try {
                    elementResult = OrcSchemaVisitor.visit(element, visitor);
                }
                finally {
                    visitor.afterElementField(element);
                }
                return visitor.list(schema, elementResult);
            }
            case MAP: {
                T valueResult;
                T keyResult;
                TypeDescription key = (TypeDescription)schema.getChildren().get(0);
                visitor.beforeKeyField(key);
                try {
                    keyResult = OrcSchemaVisitor.visit(key, visitor);
                }
                finally {
                    visitor.afterKeyField(key);
                }
                TypeDescription value = (TypeDescription)schema.getChildren().get(1);
                visitor.beforeValueField(value);
                try {
                    valueResult = OrcSchemaVisitor.visit(value, visitor);
                }
                finally {
                    visitor.afterValueField(value);
                }
                return visitor.map(schema, keyResult, valueResult);
            }
        }
        return visitor.primitive(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> visitFields(List<TypeDescription> fields, List<String> names, OrcSchemaVisitor<T> visitor) {
        Preconditions.checkArgument((fields.size() == names.size() ? 1 : 0) != 0, (Object)"Not all fields have names in ORC struct");
        ArrayList results = Lists.newArrayListWithExpectedSize((int)fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            TypeDescription field = fields.get(i);
            String name = names.get(i);
            visitor.beforeField(name, field);
            try {
                results.add(OrcSchemaVisitor.visit(field, visitor));
                continue;
            }
            finally {
                visitor.afterField(name, field);
            }
        }
        return results;
    }

    private static <T> T visitRecord(TypeDescription record, OrcSchemaVisitor<T> visitor) {
        List fields = record.getChildren();
        List names = record.getFieldNames();
        return visitor.record(record, names, OrcSchemaVisitor.visitFields(fields, names, visitor));
    }

    private static <T> T visitVariant(TypeDescription variant, OrcSchemaVisitor<T> visitor) {
        List names = variant.getFieldNames();
        Preconditions.checkArgument((names.size() == 2 && "metadata".equals(names.get(0)) && "value".equals(names.get(1)) ? 1 : 0) != 0, (String)"Invalid variant metadata fields: %s", (Object)String.join((CharSequence)", ", names));
        List children = variant.getChildren();
        T metadataResult = OrcSchemaVisitor.visit((TypeDescription)children.get(0), visitor);
        T valueResult = OrcSchemaVisitor.visit((TypeDescription)children.get(1), visitor);
        return visitor.variant(variant, metadataResult, valueResult);
    }

    public String elementName() {
        return "_elem";
    }

    public String keyName() {
        return "_key";
    }

    public String valueName() {
        return "_value";
    }

    public String currentFieldName() {
        return this.fieldNames.peek();
    }

    public void beforeField(String name, TypeDescription type) {
        this.fieldNames.push(name);
    }

    public void afterField(String name, TypeDescription type) {
        this.fieldNames.pop();
    }

    public void beforeElementField(TypeDescription element) {
        this.beforeField(this.elementName(), element);
    }

    public void afterElementField(TypeDescription element) {
        this.afterField(this.elementName(), element);
    }

    public void beforeKeyField(TypeDescription key) {
        this.beforeField(this.keyName(), key);
    }

    public void afterKeyField(TypeDescription key) {
        this.afterField(this.keyName(), key);
    }

    public void beforeValueField(TypeDescription value) {
        this.beforeField(this.valueName(), value);
    }

    public void afterValueField(TypeDescription value) {
        this.afterField(this.valueName(), value);
    }

    public T record(TypeDescription record, List<String> names, List<T> fields) {
        return null;
    }

    public T list(TypeDescription array, T element) {
        return null;
    }

    public T map(TypeDescription map, T key, T value) {
        return null;
    }

    public T variant(TypeDescription variant, T metadata, T value) {
        throw new UnsupportedOperationException("Variant is not supported");
    }

    public T primitive(TypeDescription primitive) {
        return null;
    }

    protected String[] currentPath() {
        return Lists.newArrayList(this.fieldNames.descendingIterator()).toArray(new String[0]);
    }

    protected String[] path(String name) {
        ArrayList list = Lists.newArrayList(this.fieldNames.descendingIterator());
        list.add(name);
        return list.toArray(new String[0]);
    }
}

