/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;

public abstract class OrcSchemaWithTypeVisitor<T> {
    public static <T> T visit(Schema iSchema, TypeDescription schema, OrcSchemaWithTypeVisitor<T> visitor) {
        return OrcSchemaWithTypeVisitor.visit((Type)iSchema.asStruct(), schema, visitor);
    }

    public static <T> T visit(Type iType, TypeDescription schema, OrcSchemaWithTypeVisitor<T> visitor) {
        switch (schema.getCategory()) {
            case STRUCT: {
                return OrcSchemaWithTypeVisitor.visitRecord(iType != null ? iType.asStructType() : null, schema, visitor);
            }
            case UNION: {
                throw new UnsupportedOperationException("Cannot handle " + schema);
            }
            case LIST: {
                Types.ListType list = iType != null ? iType.asListType() : null;
                return visitor.list(list, schema, OrcSchemaWithTypeVisitor.visit(list != null ? list.elementType() : null, (TypeDescription)schema.getChildren().get(0), visitor));
            }
            case MAP: {
                Types.MapType map = iType != null ? iType.asMapType() : null;
                return visitor.map(map, schema, OrcSchemaWithTypeVisitor.visit(map != null ? map.keyType() : null, (TypeDescription)schema.getChildren().get(0), visitor), OrcSchemaWithTypeVisitor.visit(map != null ? map.valueType() : null, (TypeDescription)schema.getChildren().get(1), visitor));
            }
        }
        return visitor.primitive(iType != null ? iType.asPrimitiveType() : null, schema);
    }

    private static <T> T visitRecord(Types.StructType struct, TypeDescription record, OrcSchemaWithTypeVisitor<T> visitor) {
        List fields = record.getChildren();
        List names = record.getFieldNames();
        ArrayList results = Lists.newArrayListWithExpectedSize((int)fields.size());
        for (TypeDescription field : fields) {
            int fieldId = ORCSchemaUtil.fieldId(field);
            Types.NestedField iField = struct != null ? struct.field(fieldId) : null;
            results.add(OrcSchemaWithTypeVisitor.visit(iField != null ? iField.type() : null, field, visitor));
        }
        return visitor.record(struct, record, names, results);
    }

    public T record(Types.StructType iStruct, TypeDescription record, List<String> names, List<T> fields) {
        return null;
    }

    public T list(Types.ListType iList, TypeDescription array, T element) {
        return null;
    }

    public T map(Types.MapType iMap, TypeDescription map, T key, T value) {
        return null;
    }

    public T primitive(Type.PrimitiveType iPrimitive, TypeDescription primitive) {
        return null;
    }
}

