/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class IcebergRecordObjectInspector
extends StructObjectInspector {
    private static final IcebergRecordObjectInspector EMPTY = new IcebergRecordObjectInspector(Types.StructType.of((Types.NestedField[])new Types.NestedField[0]), Collections.emptyList());
    private final List<IcebergRecordStructField> structFields;

    public IcebergRecordObjectInspector(Types.StructType structType, List<ObjectInspector> objectInspectors) {
        Preconditions.checkArgument((structType.fields().size() == objectInspectors.size() ? 1 : 0) != 0);
        this.structFields = Lists.newArrayListWithExpectedSize((int)structType.fields().size());
        int position = 0;
        for (Types.NestedField field : structType.fields()) {
            ObjectInspector oi = objectInspectors.get(position);
            Types.NestedField fieldInLowercase = Types.NestedField.of((int)field.fieldId(), (boolean)field.isOptional(), (String)field.name().toLowerCase(Locale.ROOT), (Type)field.type(), (String)field.doc());
            IcebergRecordStructField structField = new IcebergRecordStructField(fieldInLowercase, oi, position);
            this.structFields.add(structField);
            ++position;
        }
    }

    public static IcebergRecordObjectInspector empty() {
        return EMPTY;
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.structFields;
    }

    public StructField getStructFieldRef(String name) {
        return ObjectInspectorUtils.getStandardStructFieldRef((String)name, this.structFields);
    }

    public Object getStructFieldData(Object o, StructField structField) {
        if (o == null) {
            return null;
        }
        return ((Record)o).get(((IcebergRecordStructField)structField).position());
    }

    public List<Object> getStructFieldsDataAsList(Object o) {
        if (o == null) {
            return null;
        }
        Record record = (Record)o;
        return this.structFields.stream().map(f -> record.get(f.position())).collect(Collectors.toList());
    }

    public String getTypeName() {
        return ObjectInspectorUtils.getStandardStructTypeName((StructObjectInspector)this);
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IcebergRecordObjectInspector that = (IcebergRecordObjectInspector)((Object)o);
        return this.structFields.equals(that.structFields);
    }

    public int hashCode() {
        return this.structFields.hashCode();
    }

    private static class IcebergRecordStructField
    implements StructField {
        private final Types.NestedField field;
        private final ObjectInspector oi;
        private final int position;

        IcebergRecordStructField(Types.NestedField field, ObjectInspector oi, int position) {
            this.field = field;
            this.oi = oi;
            this.position = position;
        }

        public String getFieldName() {
            return this.field.name();
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.oi;
        }

        public int getFieldID() {
            return this.field.fieldId();
        }

        public String getFieldComment() {
            return this.field.doc();
        }

        int position() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IcebergRecordStructField that = (IcebergRecordStructField)o;
            return this.field.equals((Object)that.field) && this.oi.equals(that.oi) && this.position == that.position;
        }

        public int hashCode() {
            return Objects.hash(this.field, this.oi, this.position);
        }
    }
}

