/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.util.SerializationUtil;

public class HiveIcebergSplit
extends FileSplit
implements IcebergSplitContainer {
    private IcebergSplit innerSplit;
    private String tableLocation;

    public HiveIcebergSplit() {
    }

    HiveIcebergSplit(IcebergSplit split, String tableLocation) {
        this.innerSplit = split;
        this.tableLocation = tableLocation;
    }

    @Override
    public IcebergSplit icebergSplit() {
        return this.innerSplit;
    }

    public long getLength() {
        return this.innerSplit.getLength();
    }

    public String[] getLocations() {
        return this.innerSplit.getLocations();
    }

    public Path getPath() {
        return new Path(this.tableLocation);
    }

    public long getStart() {
        return 0L;
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = SerializationUtil.serializeToBytes((Object)this.tableLocation);
        out.writeInt(bytes.length);
        out.write(bytes);
        this.innerSplit.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        this.tableLocation = (String)SerializationUtil.deserializeFromBytes((byte[])bytes);
        this.innerSplit = new IcebergSplit();
        this.innerSplit.readFields(in);
    }
}

