/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.mr.hive.HiveIcebergRecordWriter;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandler;
import org.apache.iceberg.mr.hive.TezUtil;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.util.PropertyUtil;

public class HiveIcebergOutputFormat<T>
implements OutputFormat<NullWritable, Container<Record>>,
HiveOutputFormat<NullWritable, Container<Record>> {
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class valueClass, boolean isCompressed, Properties tableAndSerDeProperties, Progressable progress) {
        return HiveIcebergOutputFormat.writer(jc);
    }

    public RecordWriter<NullWritable, Container<Record>> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) {
        return HiveIcebergOutputFormat.writer(job);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) {
    }

    private static HiveIcebergRecordWriter writer(JobConf jc) {
        TaskAttemptID taskAttemptID = TezUtil.taskAttemptWrapper(jc);
        Table table = HiveIcebergStorageHandler.table((Configuration)jc, jc.get("name"));
        Schema schema = HiveIcebergStorageHandler.schema((Configuration)jc);
        PartitionSpec spec = table.spec();
        FileFormat fileFormat = FileFormat.fromString((String)PropertyUtil.propertyAsString((Map)table.properties(), (String)"write.format.default", (String)"parquet"));
        long targetFileSize = PropertyUtil.propertyAsLong((Map)table.properties(), (String)"write.target-file-size-bytes", (long)0x20000000L);
        FileIO io = table.io();
        int partitionId = taskAttemptID.getTaskID().getId();
        int taskId = taskAttemptID.getId();
        String operationId = jc.get(HiveConf.ConfVars.HIVEQUERYID.varname) + "-" + taskAttemptID.getJobID();
        OutputFileFactory outputFileFactory = OutputFileFactory.builderFor((Table)table, (int)partitionId, (long)taskId).format(fileFormat).operationId(operationId).build();
        String tableName = jc.get("name");
        return new HiveIcebergRecordWriter(schema, spec, fileFormat, (FileAppenderFactory<Record>)new GenericAppenderFactory(schema, spec), outputFileFactory, io, targetFileSize, taskAttemptID, tableName);
    }
}

