/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonView;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Documentation;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="GetMultipleContentsResponse.ContentWithKey", generator="Immutables")
@Immutable
public final class ImmutableContentWithKey
implements GetMultipleContentsResponse.ContentWithKey {
    private final ContentKey key;
    private final Content content;
    @Nullable
    private final Documentation documentation;

    private ImmutableContentWithKey(ContentKey key, Content content, @Nullable Documentation documentation) {
        this.key = Objects.requireNonNull(key, "key");
        this.content = Objects.requireNonNull(content, "content");
        this.documentation = documentation;
    }

    private ImmutableContentWithKey(ImmutableContentWithKey original, ContentKey key, Content content, @Nullable Documentation documentation) {
        this.key = key;
        this.content = content;
        this.documentation = documentation;
    }

    @Override
    @JsonProperty(value="key")
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="content")
    public Content getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="documentation")
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Documentation getDocumentation() {
        return this.documentation;
    }

    public final ImmutableContentWithKey withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableContentWithKey(this, newValue, this.content, this.documentation);
    }

    public final ImmutableContentWithKey withContent(Content value) {
        if (this.content == value) {
            return this;
        }
        Content newValue = Objects.requireNonNull(value, "content");
        return new ImmutableContentWithKey(this, this.key, newValue, this.documentation);
    }

    public final ImmutableContentWithKey withDocumentation(@Nullable Documentation value) {
        if (this.documentation == value) {
            return this;
        }
        return new ImmutableContentWithKey(this, this.key, this.content, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentWithKey && this.equalTo(0, (ImmutableContentWithKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentWithKey another) {
        return this.key.equals(another.key) && this.content.equals(another.content) && Objects.equals(this.documentation, another.documentation);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.key.hashCode();
        h2 += (h2 << 5) + this.content.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.documentation);
        return h2;
    }

    public String toString() {
        return "ContentWithKey{key=" + String.valueOf(this.key) + ", content=" + String.valueOf(this.content) + ", documentation=" + String.valueOf(this.documentation) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableContentWithKey fromJson(Json json) {
        Builder builder = ImmutableContentWithKey.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.documentation != null) {
            builder.documentation(json.documentation);
        }
        return builder.build();
    }

    public static ImmutableContentWithKey of(ContentKey key, Content content, @Nullable Documentation documentation) {
        return new ImmutableContentWithKey(key, content, documentation);
    }

    public static ImmutableContentWithKey copyOf(GetMultipleContentsResponse.ContentWithKey instance) {
        if (instance instanceof ImmutableContentWithKey) {
            return (ImmutableContentWithKey)instance;
        }
        return ImmutableContentWithKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GetMultipleContentsResponse.ContentWithKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private long initBits = 3L;
        @javax.annotation.Nullable
        private ContentKey key;
        @javax.annotation.Nullable
        private Content content;
        @javax.annotation.Nullable
        private Documentation documentation;

        private Builder() {
        }

        public final Builder from(GetMultipleContentsResponse.ContentWithKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.content(instance.getContent());
            Documentation documentationValue = instance.getDocumentation();
            if (documentationValue != null) {
                this.documentation(documentationValue);
            }
            return this;
        }

        @JsonProperty(value="key")
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="content")
        public final Builder content(Content content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="documentation")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder documentation(@Nullable Documentation documentation) {
            this.documentation = documentation;
            return this;
        }

        public ImmutableContentWithKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentWithKey(null, this.key, this.content, this.documentation);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build ContentWithKey, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GetMultipleContentsResponse.ContentWithKey", generator="Immutables")
    static final class Json
    implements GetMultipleContentsResponse.ContentWithKey {
        @javax.annotation.Nullable
        ContentKey key;
        @javax.annotation.Nullable
        Content content;
        @javax.annotation.Nullable
        Documentation documentation;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(ContentKey key) {
            this.key = key;
        }

        @JsonProperty(value="content")
        public void setContent(Content content) {
            this.content = content;
        }

        @JsonProperty(value="documentation")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setDocumentation(@Nullable Documentation documentation) {
            this.documentation = documentation;
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Documentation getDocumentation() {
            throw new UnsupportedOperationException();
        }
    }
}

