/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl.writer;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.iceberg.shaded.org.apache.orc.BinaryColumnStatistics;
import org.apache.iceberg.shaded.org.apache.orc.OrcProto;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.impl.CryptoUtils;
import org.apache.iceberg.shaded.org.apache.orc.impl.IntegerWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.PositionRecorder;
import org.apache.iceberg.shaded.org.apache.orc.impl.PositionedOutputStream;
import org.apache.iceberg.shaded.org.apache.orc.impl.StreamName;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.WriterContext;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.WriterEncryptionVariant;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;

public class BinaryTreeWriter
extends TreeWriterBase {
    private final PositionedOutputStream stream;
    private final IntegerWriter length;
    private boolean isDirectV2 = true;

    public BinaryTreeWriter(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext context) throws IOException {
        super(schema, encryption, context);
        this.stream = context.createStream(new StreamName(this.id, OrcProto.Stream.Kind.DATA, encryption));
        this.isDirectV2 = this.isNewWriteFormat(context);
        this.length = this.createIntegerWriter(context.createStream(new StreamName(this.id, OrcProto.Stream.Kind.LENGTH, encryption)), false, this.isDirectV2, context);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder result = super.getEncoding();
        if (this.isDirectV2) {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2);
        } else {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT);
        }
        return result;
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block5: {
            BytesColumnVector vec;
            block4: {
                super.writeBatch(vector, offset, length);
                vec = (BytesColumnVector)vector;
                if (!vector.isRepeating) break block4;
                if (!vector.noNulls && vector.isNull[0]) break block5;
                for (int i = 0; i < length; ++i) {
                    this.stream.write(vec.vector[0], vec.start[0], vec.length[0]);
                    this.length.write(vec.length[0]);
                }
                this.indexStatistics.updateBinary(vec.vector[0], vec.start[0], vec.length[0], length);
                if (!this.createBloomFilter) break block5;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addBytes(vec.vector[0], vec.start[0], vec.length[0]);
                }
                this.bloomFilterUtf8.addBytes(vec.vector[0], vec.start[0], vec.length[0]);
                break block5;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                this.stream.write(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
                this.length.write(vec.length[offset + i]);
                this.indexStatistics.updateBinary(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i], 1);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addBytes(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
                }
                this.bloomFilterUtf8.addBytes(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
            }
        }
    }

    @Override
    public void writeStripe(int requiredIndexEntries) throws IOException {
        super.writeStripe(requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.stream.getPosition(recorder);
        this.length.getPosition(recorder);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.stream.getBufferSize() + this.length.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        BinaryColumnStatistics bcs = (BinaryColumnStatistics)((Object)this.fileStatistics);
        return bcs.getSum();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.stream.flush();
        this.length.flush();
    }

    @Override
    public void prepareStripe(int stripeId) {
        super.prepareStripe(stripeId);
        Consumer<byte[]> updater = CryptoUtils.modifyIvForStripe(stripeId);
        this.stream.changeIv(updater);
        this.length.changeIv(updater);
    }
}

