/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.HttpRoute;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.UserTokenHandler;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.impl.ProtocolSwitchStrategy;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.iceberg.shaded.org.apache.hc.core5.annotation.Contract;
import org.apache.iceberg.shaded.org.apache.hc.core5.annotation.Internal;
import org.apache.iceberg.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.iceberg.shaded.org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.iceberg.shaded.org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.EntityDetails;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.Header;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.HttpException;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.HttpRequest;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.HttpResponse;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ProtocolException;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ProtocolVersion;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.message.RequestLine;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.iceberg.shaded.org.apache.hc.core5.util.Args;
import org.apache.iceberg.shaded.org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
class HttpAsyncMainClientExec
implements AsyncExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpAsyncMainClientExec.class);
    private final HttpProcessor httpProcessor;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final UserTokenHandler userTokenHandler;
    private final ProtocolSwitchStrategy protocolSwitchStrategy;

    HttpAsyncMainClientExec(HttpProcessor httpProcessor, ConnectionKeepAliveStrategy keepAliveStrategy, UserTokenHandler userTokenHandler) {
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP protocol processor");
        this.keepAliveStrategy = keepAliveStrategy;
        this.userTokenHandler = userTokenHandler;
        this.protocolSwitchStrategy = new ProtocolSwitchStrategy();
    }

    @Override
    public void execute(final HttpRequest request, final AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        String exchangeId = scope.exchangeId;
        final HttpRoute route = scope.route;
        CancellableDependency operation = scope.cancellableDependency;
        final HttpClientContext clientContext = scope.clientContext;
        final AsyncExecRuntime execRuntime = scope.execRuntime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} executing {}", (Object)exchangeId, (Object)new RequestLine(request));
        }
        final AtomicInteger messageCountDown = new AtomicInteger(2);
        AsyncClientExchangeHandler internalExchangeHandler = new AsyncClientExchangeHandler(){
            private final AtomicReference<AsyncDataConsumer> entityConsumerRef = new AtomicReference();

            @Override
            public void releaseResources() {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.releaseResources();
                }
            }

            @Override
            public void failed(Exception cause) {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.releaseResources();
                }
                execRuntime.markConnectionNonReusable();
                asyncExecCallback.failed(cause);
            }

            @Override
            public void cancel() {
                if (messageCountDown.get() > 0) {
                    this.failed(new InterruptedIOException());
                }
            }

            @Override
            public void produceRequest(RequestChannel channel, HttpContext context) throws HttpException, IOException {
                clientContext.setRoute(route);
                clientContext.setRequest(request);
                HttpAsyncMainClientExec.this.httpProcessor.process(request, (EntityDetails)entityProducer, (HttpContext)clientContext);
                channel.sendRequest(request, entityProducer, context);
                if (entityProducer == null) {
                    messageCountDown.decrementAndGet();
                }
            }

            @Override
            public int available() {
                return entityProducer.available();
            }

            @Override
            public void produce(final DataStreamChannel channel) throws IOException {
                entityProducer.produce(new DataStreamChannel(){

                    @Override
                    public void requestOutput() {
                        channel.requestOutput();
                    }

                    @Override
                    public int write(ByteBuffer src) throws IOException {
                        return channel.write(src);
                    }

                    @Override
                    public void endStream(List<? extends Header> trailers) throws IOException {
                        channel.endStream(trailers);
                        if (messageCountDown.decrementAndGet() <= 0) {
                            asyncExecCallback.completed();
                        }
                    }

                    @Override
                    public void endStream() throws IOException {
                        channel.endStream();
                        if (messageCountDown.decrementAndGet() <= 0) {
                            asyncExecCallback.completed();
                        }
                    }
                });
            }

            @Override
            public void consumeInformation(HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (response.getCode() == 101) {
                    final ProtocolVersion upgradeProtocol = HttpAsyncMainClientExec.this.protocolSwitchStrategy.switchProtocol(response);
                    if (upgradeProtocol == null || !upgradeProtocol.getProtocol().equals("TLS")) {
                        throw new ProtocolException("Failure switching protocols");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Switching to {}", (Object)upgradeProtocol);
                    }
                    execRuntime.upgradeTls(clientContext, new FutureCallback<AsyncExecRuntime>(){

                        @Override
                        public void completed(AsyncExecRuntime result) {
                            LOG.debug("Successfully switched to {}", (Object)upgradeProtocol);
                        }

                        @Override
                        public void failed(Exception ex) {
                            asyncExecCallback.failed(ex);
                        }

                        @Override
                        public void cancelled() {
                            asyncExecCallback.failed(new InterruptedIOException());
                        }
                    });
                } else {
                    asyncExecCallback.handleInformationResponse(response);
                }
            }

            @Override
            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
                clientContext.setResponse(response);
                HttpAsyncMainClientExec.this.httpProcessor.process(response, entityDetails, (HttpContext)clientContext);
                this.entityConsumerRef.set(asyncExecCallback.handleResponse(response, entityDetails));
                if (response.getCode() >= 400) {
                    messageCountDown.decrementAndGet();
                }
                TimeValue keepAliveDuration = HttpAsyncMainClientExec.this.keepAliveStrategy.getKeepAliveDuration(response, clientContext);
                Object userToken = clientContext.getUserToken();
                if (userToken == null) {
                    userToken = HttpAsyncMainClientExec.this.userTokenHandler.getUserToken(route, request, clientContext);
                    clientContext.setUserToken(userToken);
                }
                execRuntime.markConnectionReusable(userToken, keepAliveDuration);
                if (entityDetails == null) {
                    execRuntime.validateConnection();
                    if (messageCountDown.decrementAndGet() <= 0) {
                        asyncExecCallback.completed();
                    }
                }
            }

            @Override
            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    entityConsumer.updateCapacity(capacityChannel);
                } else {
                    capacityChannel.update(Integer.MAX_VALUE);
                }
            }

            @Override
            public void consume(ByteBuffer src) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    entityConsumer.consume(src);
                }
            }

            @Override
            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.streamEnd(trailers);
                } else {
                    execRuntime.validateConnection();
                }
                if (messageCountDown.decrementAndGet() <= 0) {
                    asyncExecCallback.completed();
                }
            }
        };
        if (LOG.isDebugEnabled()) {
            operation.setDependency(execRuntime.execute(exchangeId, new LoggingAsyncClientExchangeHandler(LOG, exchangeId, internalExchangeHandler), clientContext));
        } else {
            operation.setDependency(execRuntime.execute(exchangeId, internalExchangeHandler, clientContext));
        }
    }
}

