/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class RESTUtil {
    private static final char NAMESPACE_SEPARATOR = '\u001f';
    public static final Joiner NAMESPACE_JOINER = Joiner.on('\u001f');
    public static final Splitter NAMESPACE_SPLITTER = Splitter.on('\u001f');
    private static final String NAMESPACE_ESCAPED_SEPARATOR = "%1F";
    private static final Joiner NAMESPACE_ESCAPED_JOINER = Joiner.on("%1F");
    private static final Splitter NAMESPACE_ESCAPED_SPLITTER = Splitter.on("%1F");
    private static final Joiner.MapJoiner FORM_JOINER = Joiner.on("&").withKeyValueSeparator("=");
    private static final Splitter.MapSplitter FORM_SPLITTER = Splitter.on("&").withKeyValueSeparator("=");

    private RESTUtil() {
    }

    public static String stripTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        String result = path;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Map<String, String> merge(Map<String, String> target, Map<String, String> updates) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        target.forEach((key, value) -> {
            if (!updates.containsKey(key)) {
                builder.put(key, value);
            }
        });
        updates.forEach(builder::put);
        return builder.build();
    }

    public static Map<String, String> extractPrefixMap(Map<String, String> properties, String prefix) {
        Preconditions.checkNotNull(properties, "Invalid properties map: null");
        HashMap<String, String> result = Maps.newHashMap();
        properties.forEach((key, value) -> {
            if (key != null && key.startsWith(prefix)) {
                result.put(key.substring(prefix.length()), (String)value);
            }
        });
        return result;
    }

    public static String encodeFormData(Map<?, ?> formData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        formData.forEach((key, value) -> builder.put(RESTUtil.encodeString(String.valueOf(key)), RESTUtil.encodeString(String.valueOf(value))));
        return FORM_JOINER.join(builder.build());
    }

    public static Map<String, String> decodeFormData(String formString) {
        return FORM_SPLITTER.split(formString).entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> RESTUtil.decodeString((String)e.getKey()), e -> RESTUtil.decodeString((String)e.getValue())));
    }

    public static String encodeString(String toEncode) {
        Preconditions.checkArgument(toEncode != null, "Invalid string to encode: null");
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL encode '%s': UTF-8 encoding is not supported", toEncode), e);
        }
    }

    public static String decodeString(String encoded) {
        Preconditions.checkArgument(encoded != null, "Invalid string to decode: null");
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL decode '%s': UTF-8 encoding is not supported", encoded), e);
        }
    }

    public static String encodeNamespace(Namespace ns) {
        Preconditions.checkArgument(ns != null, "Invalid namespace: null");
        String[] levels = ns.levels();
        Object[] encodedLevels = new String[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            encodedLevels[i] = RESTUtil.encodeString(levels[i]);
        }
        return NAMESPACE_ESCAPED_JOINER.join(encodedLevels);
    }

    public static Namespace decodeNamespace(String encodedNs) {
        Preconditions.checkArgument(encodedNs != null, "Invalid namespace: null");
        String[] levels = Iterables.toArray(NAMESPACE_ESCAPED_SPLITTER.split(encodedNs), String.class);
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = RESTUtil.decodeString(levels[i]);
        }
        return Namespace.of(levels);
    }

    public static String resolveEndpoint(String catalogUri, String endpointPath) {
        if (null == endpointPath) {
            return null;
        }
        if (null == catalogUri || endpointPath.startsWith("http://") || endpointPath.startsWith("https://")) {
            return endpointPath;
        }
        return String.format("%s%s", RESTUtil.stripTrailingSlash(catalogUri), endpointPath.startsWith("/") ? endpointPath : "/" + endpointPath);
    }
}

