/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.iceberg.aws.s3.BaseS3File;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.aws.s3.S3OutputStream;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.encryption.NativeFileCryptoParameters;
import org.apache.iceberg.encryption.NativelyEncryptedFile;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.metrics.MetricsContext;
import software.amazon.awssdk.services.s3.S3Client;

public class S3OutputFile
extends BaseS3File
implements OutputFile,
NativelyEncryptedFile {
    private NativeFileCryptoParameters nativeEncryptionParameters;

    public static S3OutputFile fromLocation(String location, S3Client client, S3FileIOProperties s3FileIOProperties, MetricsContext metrics) {
        return new S3OutputFile(client, new S3URI(location, s3FileIOProperties.bucketToAccessPointMapping()), s3FileIOProperties, metrics);
    }

    S3OutputFile(S3Client client, S3URI uri, S3FileIOProperties s3FileIOProperties, MetricsContext metrics) {
        super(client, uri, s3FileIOProperties, metrics);
    }

    @Override
    public PositionOutputStream create() {
        if (!this.exists()) {
            return this.createOrOverwrite();
        }
        throw new AlreadyExistsException("Location already exists: %s", this.uri());
    }

    @Override
    public PositionOutputStream createOrOverwrite() {
        try {
            return new S3OutputStream(this.client(), this.uri(), this.s3FileIOProperties(), this.metrics());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create output stream for location: " + this.uri(), e);
        }
    }

    @Override
    public InputFile toInputFile() {
        return new S3InputFile(this.client(), this.uri(), null, this.s3FileIOProperties(), this.metrics());
    }

    @Override
    public NativeFileCryptoParameters nativeCryptoParameters() {
        return this.nativeEncryptionParameters;
    }

    @Override
    public void setNativeCryptoParameters(NativeFileCryptoParameters nativeCryptoParameters) {
        this.nativeEncryptionParameters = nativeCryptoParameters;
    }
}

