/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aliyun.oss;

import com.aliyun.oss.internal.OSSUtils;
import java.util.Locale;
import java.util.Set;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;

public class OSSURI {
    private static final String SCHEME_DELIM = "://";
    private static final String PATH_DELIM = "/";
    private static final String QUERY_DELIM = "\\?";
    private static final String FRAGMENT_DELIM = "#";
    private static final Set<String> VALID_SCHEMES = ImmutableSet.of("https", "oss");
    private final String location;
    private final String bucket;
    private final String key;

    public OSSURI(String location) {
        Preconditions.checkNotNull(location, "OSS location cannot be null.");
        this.location = location;
        String[] schemeSplit = location.split(SCHEME_DELIM, -1);
        ValidationException.check(schemeSplit.length == 2, "Invalid OSS location: %s", location);
        String scheme = schemeSplit[0];
        ValidationException.check(VALID_SCHEMES.contains(scheme.toLowerCase(Locale.ROOT)), "Invalid scheme: %s in OSS location %s", scheme, location);
        String[] authoritySplit = schemeSplit[1].split(PATH_DELIM, 2);
        ValidationException.check(authoritySplit.length == 2, "Invalid bucket or key in OSS location: %s", location);
        ValidationException.check(!authoritySplit[1].trim().isEmpty(), "Missing key in OSS location: %s", location);
        this.bucket = authoritySplit[0];
        OSSUtils.ensureBucketNameValid((String)this.bucket);
        String path = authoritySplit[1];
        path = path.split(QUERY_DELIM, -1)[0];
        this.key = path = path.split(FRAGMENT_DELIM, -1)[0];
        OSSUtils.ensureObjectKeyValid((String)this.key);
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String location() {
        return this.location;
    }

    public String toString() {
        return this.location;
    }
}

