/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonView;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="GetNamespacesResponse", generator="Immutables")
@Immutable
public final class ImmutableGetNamespacesResponse
implements GetNamespacesResponse {
    private final List<Namespace> namespaces;
    @Nullable
    private final Reference effectiveReference;

    private ImmutableGetNamespacesResponse(List<Namespace> namespaces, @Nullable Reference effectiveReference) {
        this.namespaces = namespaces;
        this.effectiveReference = effectiveReference;
    }

    @Override
    @JsonProperty(value="namespaces")
    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @Override
    @JsonProperty(value="effectiveReference")
    @JsonView(value={Views.V2.class})
    @Nullable
    public Reference getEffectiveReference() {
        return this.effectiveReference;
    }

    public final ImmutableGetNamespacesResponse withNamespaces(Namespace ... elements) {
        List<Namespace> newValue = ImmutableGetNamespacesResponse.createUnmodifiableList(false, ImmutableGetNamespacesResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetNamespacesResponse(newValue, this.effectiveReference);
    }

    public final ImmutableGetNamespacesResponse withNamespaces(Iterable<? extends Namespace> elements) {
        if (this.namespaces == elements) {
            return this;
        }
        List<Namespace> newValue = ImmutableGetNamespacesResponse.createUnmodifiableList(false, ImmutableGetNamespacesResponse.createSafeList(elements, true, false));
        return new ImmutableGetNamespacesResponse(newValue, this.effectiveReference);
    }

    public final ImmutableGetNamespacesResponse withEffectiveReference(@Nullable Reference value) {
        if (this.effectiveReference == value) {
            return this;
        }
        return new ImmutableGetNamespacesResponse(this.namespaces, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetNamespacesResponse && this.equalTo(0, (ImmutableGetNamespacesResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetNamespacesResponse another) {
        return this.namespaces.equals(another.namespaces) && Objects.equals(this.effectiveReference, another.effectiveReference);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.namespaces.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.effectiveReference);
        return h2;
    }

    public String toString() {
        return "GetNamespacesResponse{namespaces=" + String.valueOf(this.namespaces) + ", effectiveReference=" + String.valueOf(this.effectiveReference) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGetNamespacesResponse fromJson(Json json) {
        Builder builder = ImmutableGetNamespacesResponse.builder();
        if (json.namespaces != null) {
            builder.addAllNamespaces(json.namespaces);
        }
        if (json.effectiveReference != null) {
            builder.effectiveReference(json.effectiveReference);
        }
        return builder.build();
    }

    public static ImmutableGetNamespacesResponse copyOf(GetNamespacesResponse instance) {
        if (instance instanceof ImmutableGetNamespacesResponse) {
            return (ImmutableGetNamespacesResponse)instance;
        }
        return ImmutableGetNamespacesResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GetNamespacesResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Namespace> namespaces = new ArrayList<Namespace>();
        @javax.annotation.Nullable
        private Reference effectiveReference;

        private Builder() {
        }

        public final Builder from(GetNamespacesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllNamespaces(instance.getNamespaces());
            Reference effectiveReferenceValue = instance.getEffectiveReference();
            if (effectiveReferenceValue != null) {
                this.effectiveReference(effectiveReferenceValue);
            }
            return this;
        }

        public final Builder addNamespaces(Namespace element) {
            this.namespaces.add(Objects.requireNonNull(element, "namespaces element"));
            return this;
        }

        public final Builder addNamespaces(Namespace ... elements) {
            for (Namespace element : elements) {
                this.namespaces.add(Objects.requireNonNull(element, "namespaces element"));
            }
            return this;
        }

        @JsonProperty(value="namespaces")
        public final Builder namespaces(Iterable<? extends Namespace> elements) {
            this.namespaces.clear();
            return this.addAllNamespaces(elements);
        }

        public final Builder addAllNamespaces(Iterable<? extends Namespace> elements) {
            for (Namespace namespace : elements) {
                this.namespaces.add(Objects.requireNonNull(namespace, "namespaces element"));
            }
            return this;
        }

        @JsonProperty(value="effectiveReference")
        @JsonView(value={Views.V2.class})
        public final Builder effectiveReference(@Nullable Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
            return this;
        }

        public ImmutableGetNamespacesResponse build() {
            return new ImmutableGetNamespacesResponse(ImmutableGetNamespacesResponse.createUnmodifiableList(true, this.namespaces), this.effectiveReference);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GetNamespacesResponse", generator="Immutables")
    static final class Json
    implements GetNamespacesResponse {
        @javax.annotation.Nullable
        List<Namespace> namespaces = Collections.emptyList();
        @javax.annotation.Nullable
        Reference effectiveReference;

        Json() {
        }

        @JsonProperty(value="namespaces")
        public void setNamespaces(List<Namespace> namespaces) {
            this.namespaces = namespaces;
        }

        @JsonProperty(value="effectiveReference")
        @JsonView(value={Views.V2.class})
        public void setEffectiveReference(@Nullable Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
        }

        @Override
        public List<Namespace> getNamespaces() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference getEffectiveReference() {
            throw new UnsupportedOperationException();
        }
    }
}

