/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v2;

import java.util.Arrays;
import java.util.Optional;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignReferenceBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateReferenceBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteReferenceBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetDiffBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetReferenceBuilder;
import org.projectnessie.client.api.GetRepositoryConfigBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.api.ReferenceHistoryBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.api.UpdateRepositoryConfigBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.rest.v2.HttpAssignBranch;
import org.projectnessie.client.rest.v2.HttpAssignReference;
import org.projectnessie.client.rest.v2.HttpAssignTag;
import org.projectnessie.client.rest.v2.HttpCommitMultipleOperations;
import org.projectnessie.client.rest.v2.HttpCreateReference;
import org.projectnessie.client.rest.v2.HttpDeleteBranch;
import org.projectnessie.client.rest.v2.HttpDeleteReference;
import org.projectnessie.client.rest.v2.HttpDeleteTag;
import org.projectnessie.client.rest.v2.HttpGetAllReferences;
import org.projectnessie.client.rest.v2.HttpGetCommitLog;
import org.projectnessie.client.rest.v2.HttpGetContent;
import org.projectnessie.client.rest.v2.HttpGetDiff;
import org.projectnessie.client.rest.v2.HttpGetEntries;
import org.projectnessie.client.rest.v2.HttpGetReference;
import org.projectnessie.client.rest.v2.HttpGetRepositoryConfig;
import org.projectnessie.client.rest.v2.HttpMergeReference;
import org.projectnessie.client.rest.v2.HttpReferenceHistory;
import org.projectnessie.client.rest.v2.HttpTransplantCommits;
import org.projectnessie.client.rest.v2.HttpUpdateRepositoryConfig;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.Reference;
import org.projectnessie.model.SingleReferenceResponse;

public class HttpApiV2
implements NessieApiV2 {
    private final HttpClient client;
    private volatile boolean didGetConfig;
    private volatile boolean isNessieSpec220;

    public HttpApiV2(HttpClient client) {
        this.client = client;
    }

    boolean isNessieSpec220() {
        if (!this.didGetConfig) {
            this.getConfig();
        }
        return this.isNessieSpec220;
    }

    String toPathString(ContentKey key) {
        return this.isNessieSpec220() ? key.toPathStringEscaped() : key.toPathString();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public <C> Optional<C> unwrapClient(Class<C> clientType) {
        return clientType.isAssignableFrom(HttpClient.class) ? Optional.of(clientType.cast(this.client)) : Optional.empty();
    }

    @Override
    public NessieConfiguration getConfig() {
        NessieConfiguration config = this.client.newRequest().path("config").get().readEntity(NessieConfiguration.class);
        this.didGetConfig = true;
        if (config.getSpecVersion() != null) {
            int[] parts = Arrays.stream(config.getSpecVersion().split("[.]")).mapToInt(Integer::parseInt).toArray();
            this.isNessieSpec220 = parts[0] > 2 || parts[0] == 2 && parts[1] >= 2;
        }
        return config;
    }

    @Override
    public Branch getDefaultBranch() throws NessieNotFoundException {
        return (Branch)this.client.newRequest().path("trees/-").unwrap(NessieNotFoundException.class).get().readEntity(SingleReferenceResponse.class).getReference();
    }

    @Override
    public GetContentBuilder getContent() {
        return new HttpGetContent(this.client, this);
    }

    @Override
    public GetAllReferencesBuilder getAllReferences() {
        return new HttpGetAllReferences(this.client);
    }

    @Override
    public CreateReferenceBuilder createReference() {
        return new HttpCreateReference(this.client);
    }

    @Override
    public GetReferenceBuilder getReference() {
        return new HttpGetReference(this.client);
    }

    @Override
    public ReferenceHistoryBuilder referenceHistory() {
        return new HttpReferenceHistory(this.client);
    }

    @Override
    public GetEntriesBuilder getEntries() {
        return new HttpGetEntries(this.client, this);
    }

    @Override
    public GetCommitLogBuilder getCommitLog() {
        return new HttpGetCommitLog(this.client);
    }

    @Override
    @Deprecated
    public AssignTagBuilder assignTag() {
        return new HttpAssignTag(this.client);
    }

    @Override
    @Deprecated
    public DeleteTagBuilder deleteTag() {
        return new HttpDeleteTag(this.client);
    }

    @Override
    @Deprecated
    public AssignBranchBuilder assignBranch() {
        return new HttpAssignBranch(this.client);
    }

    @Override
    @Deprecated
    public DeleteBranchBuilder deleteBranch() {
        return new HttpDeleteBranch(this.client);
    }

    @Override
    public AssignReferenceBuilder<Reference> assignReference() {
        return new HttpAssignReference(this.client);
    }

    @Override
    public DeleteReferenceBuilder<Reference> deleteReference() {
        return new HttpDeleteReference(this.client);
    }

    @Override
    public TransplantCommitsBuilder transplantCommitsIntoBranch() {
        return new HttpTransplantCommits(this.client);
    }

    @Override
    public MergeReferenceBuilder mergeRefIntoBranch() {
        return new HttpMergeReference(this.client);
    }

    @Override
    public CommitMultipleOperationsBuilder commitMultipleOperations() {
        return new HttpCommitMultipleOperations(this.client);
    }

    @Override
    public GetDiffBuilder getDiff() {
        return new HttpGetDiff(this.client, this);
    }

    @Override
    public GetRepositoryConfigBuilder getRepositoryConfig() {
        return new HttpGetRepositoryConfig(this.client);
    }

    @Override
    public UpdateRepositoryConfigBuilder updateRepositoryConfig() {
        return new HttpUpdateRepositoryConfig(this.client);
    }
}

