/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.avro;

import org.apache.iceberg.shaded.org.apache.avro.AvroRuntimeException;
import org.apache.iceberg.shaded.org.apache.avro.JsonSchemaFormatter;
import org.apache.iceberg.shaded.org.apache.avro.SchemaFormatter;
import org.apache.iceberg.shaded.org.apache.avro.SchemaFormatterFactory;

public class JsonSchemaFormatterFactory
implements SchemaFormatterFactory {
    public static final String VARIANT_NAME_PRETTY = "pretty";
    public static final String VARIANT_NAME_INLINE = "inline";

    @Override
    public SchemaFormatter getDefaultFormatter() {
        return this.getFormatterForVariant(VARIANT_NAME_PRETTY);
    }

    @Override
    public SchemaFormatter getFormatterForVariant(String variantName) {
        if (VARIANT_NAME_PRETTY.equals(variantName)) {
            return new JsonSchemaFormatter(true);
        }
        if (VARIANT_NAME_INLINE.equals(variantName)) {
            return new JsonSchemaFormatter(false);
        }
        throw new AvroRuntimeException("Unknown JSON variant: " + variantName);
    }
}

