/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.metrics.Timer;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ScanMetrics", generator="Immutables")
@Immutable
public final class ImmutableScanMetrics
extends ScanMetrics {
    private final MetricsContext metricsContext;
    private final transient Timer totalPlanningDuration;
    private final transient Counter resultDataFiles;
    private final transient Counter resultDeleteFiles;
    private final transient Counter scannedDataManifests;
    private final transient Counter totalDataManifests;
    private final transient Counter totalDeleteManifests;
    private final transient Counter totalFileSizeInBytes;
    private final transient Counter totalDeleteFileSizeInBytes;
    private final transient Counter skippedDataManifests;
    private final transient Counter skippedDataFiles;
    private final transient Counter skippedDeleteFiles;
    private final transient Counter scannedDeleteManifests;
    private final transient Counter skippedDeleteManifests;
    private final transient Counter indexedDeleteFiles;
    private final transient Counter equalityDeleteFiles;
    private final transient Counter positionalDeleteFiles;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableScanMetrics(MetricsContext metricsContext) {
        this.metricsContext = metricsContext;
        this.totalPlanningDuration = this.initShim.totalPlanningDuration();
        this.resultDataFiles = this.initShim.resultDataFiles();
        this.resultDeleteFiles = this.initShim.resultDeleteFiles();
        this.scannedDataManifests = this.initShim.scannedDataManifests();
        this.totalDataManifests = this.initShim.totalDataManifests();
        this.totalDeleteManifests = this.initShim.totalDeleteManifests();
        this.totalFileSizeInBytes = this.initShim.totalFileSizeInBytes();
        this.totalDeleteFileSizeInBytes = this.initShim.totalDeleteFileSizeInBytes();
        this.skippedDataManifests = this.initShim.skippedDataManifests();
        this.skippedDataFiles = this.initShim.skippedDataFiles();
        this.skippedDeleteFiles = this.initShim.skippedDeleteFiles();
        this.scannedDeleteManifests = this.initShim.scannedDeleteManifests();
        this.skippedDeleteManifests = this.initShim.skippedDeleteManifests();
        this.indexedDeleteFiles = this.initShim.indexedDeleteFiles();
        this.equalityDeleteFiles = this.initShim.equalityDeleteFiles();
        this.positionalDeleteFiles = this.initShim.positionalDeleteFiles();
        this.initShim = null;
    }

    @Override
    public MetricsContext metricsContext() {
        return this.metricsContext;
    }

    @Override
    public Timer totalPlanningDuration() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalPlanningDuration() : this.totalPlanningDuration;
    }

    @Override
    public Counter resultDataFiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.resultDataFiles() : this.resultDataFiles;
    }

    @Override
    public Counter resultDeleteFiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.resultDeleteFiles() : this.resultDeleteFiles;
    }

    @Override
    public Counter scannedDataManifests() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scannedDataManifests() : this.scannedDataManifests;
    }

    @Override
    public Counter totalDataManifests() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalDataManifests() : this.totalDataManifests;
    }

    @Override
    public Counter totalDeleteManifests() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalDeleteManifests() : this.totalDeleteManifests;
    }

    @Override
    public Counter totalFileSizeInBytes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalFileSizeInBytes() : this.totalFileSizeInBytes;
    }

    @Override
    public Counter totalDeleteFileSizeInBytes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalDeleteFileSizeInBytes() : this.totalDeleteFileSizeInBytes;
    }

    @Override
    public Counter skippedDataManifests() {
        InitShim shim = this.initShim;
        return shim != null ? shim.skippedDataManifests() : this.skippedDataManifests;
    }

    @Override
    public Counter skippedDataFiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.skippedDataFiles() : this.skippedDataFiles;
    }

    @Override
    public Counter skippedDeleteFiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.skippedDeleteFiles() : this.skippedDeleteFiles;
    }

    @Override
    public Counter scannedDeleteManifests() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scannedDeleteManifests() : this.scannedDeleteManifests;
    }

    @Override
    public Counter skippedDeleteManifests() {
        InitShim shim = this.initShim;
        return shim != null ? shim.skippedDeleteManifests() : this.skippedDeleteManifests;
    }

    @Override
    public Counter indexedDeleteFiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.indexedDeleteFiles() : this.indexedDeleteFiles;
    }

    @Override
    public Counter equalityDeleteFiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.equalityDeleteFiles() : this.equalityDeleteFiles;
    }

    @Override
    public Counter positionalDeleteFiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.positionalDeleteFiles() : this.positionalDeleteFiles;
    }

    public final ImmutableScanMetrics withMetricsContext(MetricsContext value) {
        if (this.metricsContext == value) {
            return this;
        }
        MetricsContext newValue = Objects.requireNonNull(value, "metricsContext");
        return new ImmutableScanMetrics(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScanMetrics && this.equalTo(0, (ImmutableScanMetrics)another);
    }

    private boolean equalTo(int synthetic, ImmutableScanMetrics another) {
        return this.metricsContext.equals(another.metricsContext) && this.totalPlanningDuration.equals(another.totalPlanningDuration) && this.resultDataFiles.equals(another.resultDataFiles) && this.resultDeleteFiles.equals(another.resultDeleteFiles) && this.scannedDataManifests.equals(another.scannedDataManifests) && this.totalDataManifests.equals(another.totalDataManifests) && this.totalDeleteManifests.equals(another.totalDeleteManifests) && this.totalFileSizeInBytes.equals(another.totalFileSizeInBytes) && this.totalDeleteFileSizeInBytes.equals(another.totalDeleteFileSizeInBytes) && this.skippedDataManifests.equals(another.skippedDataManifests) && this.skippedDataFiles.equals(another.skippedDataFiles) && this.skippedDeleteFiles.equals(another.skippedDeleteFiles) && this.scannedDeleteManifests.equals(another.scannedDeleteManifests) && this.skippedDeleteManifests.equals(another.skippedDeleteManifests) && this.indexedDeleteFiles.equals(another.indexedDeleteFiles) && this.equalityDeleteFiles.equals(another.equalityDeleteFiles) && this.positionalDeleteFiles.equals(another.positionalDeleteFiles);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.metricsContext.hashCode();
        h2 += (h2 << 5) + this.totalPlanningDuration.hashCode();
        h2 += (h2 << 5) + this.resultDataFiles.hashCode();
        h2 += (h2 << 5) + this.resultDeleteFiles.hashCode();
        h2 += (h2 << 5) + this.scannedDataManifests.hashCode();
        h2 += (h2 << 5) + this.totalDataManifests.hashCode();
        h2 += (h2 << 5) + this.totalDeleteManifests.hashCode();
        h2 += (h2 << 5) + this.totalFileSizeInBytes.hashCode();
        h2 += (h2 << 5) + this.totalDeleteFileSizeInBytes.hashCode();
        h2 += (h2 << 5) + this.skippedDataManifests.hashCode();
        h2 += (h2 << 5) + this.skippedDataFiles.hashCode();
        h2 += (h2 << 5) + this.skippedDeleteFiles.hashCode();
        h2 += (h2 << 5) + this.scannedDeleteManifests.hashCode();
        h2 += (h2 << 5) + this.skippedDeleteManifests.hashCode();
        h2 += (h2 << 5) + this.indexedDeleteFiles.hashCode();
        h2 += (h2 << 5) + this.equalityDeleteFiles.hashCode();
        h2 += (h2 << 5) + this.positionalDeleteFiles.hashCode();
        return h2;
    }

    public String toString() {
        return "ScanMetrics{metricsContext=" + this.metricsContext + ", totalPlanningDuration=" + this.totalPlanningDuration + ", resultDataFiles=" + this.resultDataFiles + ", resultDeleteFiles=" + this.resultDeleteFiles + ", scannedDataManifests=" + this.scannedDataManifests + ", totalDataManifests=" + this.totalDataManifests + ", totalDeleteManifests=" + this.totalDeleteManifests + ", totalFileSizeInBytes=" + this.totalFileSizeInBytes + ", totalDeleteFileSizeInBytes=" + this.totalDeleteFileSizeInBytes + ", skippedDataManifests=" + this.skippedDataManifests + ", skippedDataFiles=" + this.skippedDataFiles + ", skippedDeleteFiles=" + this.skippedDeleteFiles + ", scannedDeleteManifests=" + this.scannedDeleteManifests + ", skippedDeleteManifests=" + this.skippedDeleteManifests + ", indexedDeleteFiles=" + this.indexedDeleteFiles + ", equalityDeleteFiles=" + this.equalityDeleteFiles + ", positionalDeleteFiles=" + this.positionalDeleteFiles + "}";
    }

    public static ImmutableScanMetrics copyOf(ScanMetrics instance) {
        if (instance instanceof ImmutableScanMetrics) {
            return (ImmutableScanMetrics)instance;
        }
        return ImmutableScanMetrics.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ScanMetrics", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METRICS_CONTEXT = 1L;
        private long initBits = 1L;
        @Nullable
        private MetricsContext metricsContext;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ScanMetrics instance) {
            Objects.requireNonNull(instance, "instance");
            this.metricsContext(instance.metricsContext());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsContext(MetricsContext metricsContext) {
            this.metricsContext = Objects.requireNonNull(metricsContext, "metricsContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableScanMetrics build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScanMetrics(this.metricsContext);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metricsContext");
            }
            return "Cannot build ScanMetrics, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ScanMetrics", generator="Immutables")
    private final class InitShim {
        private byte totalPlanningDurationBuildStage = 0;
        private Timer totalPlanningDuration;
        private byte resultDataFilesBuildStage = 0;
        private Counter resultDataFiles;
        private byte resultDeleteFilesBuildStage = 0;
        private Counter resultDeleteFiles;
        private byte scannedDataManifestsBuildStage = 0;
        private Counter scannedDataManifests;
        private byte totalDataManifestsBuildStage = 0;
        private Counter totalDataManifests;
        private byte totalDeleteManifestsBuildStage = 0;
        private Counter totalDeleteManifests;
        private byte totalFileSizeInBytesBuildStage = 0;
        private Counter totalFileSizeInBytes;
        private byte totalDeleteFileSizeInBytesBuildStage = 0;
        private Counter totalDeleteFileSizeInBytes;
        private byte skippedDataManifestsBuildStage = 0;
        private Counter skippedDataManifests;
        private byte skippedDataFilesBuildStage = 0;
        private Counter skippedDataFiles;
        private byte skippedDeleteFilesBuildStage = 0;
        private Counter skippedDeleteFiles;
        private byte scannedDeleteManifestsBuildStage = 0;
        private Counter scannedDeleteManifests;
        private byte skippedDeleteManifestsBuildStage = 0;
        private Counter skippedDeleteManifests;
        private byte indexedDeleteFilesBuildStage = 0;
        private Counter indexedDeleteFiles;
        private byte equalityDeleteFilesBuildStage = 0;
        private Counter equalityDeleteFiles;
        private byte positionalDeleteFilesBuildStage = 0;
        private Counter positionalDeleteFiles;

        private InitShim() {
        }

        Timer totalPlanningDuration() {
            if (this.totalPlanningDurationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalPlanningDurationBuildStage == 0) {
                this.totalPlanningDurationBuildStage = (byte)-1;
                this.totalPlanningDuration = Objects.requireNonNull(ImmutableScanMetrics.super.totalPlanningDuration(), "totalPlanningDuration");
                this.totalPlanningDurationBuildStage = 1;
            }
            return this.totalPlanningDuration;
        }

        Counter resultDataFiles() {
            if (this.resultDataFilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.resultDataFilesBuildStage == 0) {
                this.resultDataFilesBuildStage = (byte)-1;
                this.resultDataFiles = Objects.requireNonNull(ImmutableScanMetrics.super.resultDataFiles(), "resultDataFiles");
                this.resultDataFilesBuildStage = 1;
            }
            return this.resultDataFiles;
        }

        Counter resultDeleteFiles() {
            if (this.resultDeleteFilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.resultDeleteFilesBuildStage == 0) {
                this.resultDeleteFilesBuildStage = (byte)-1;
                this.resultDeleteFiles = Objects.requireNonNull(ImmutableScanMetrics.super.resultDeleteFiles(), "resultDeleteFiles");
                this.resultDeleteFilesBuildStage = 1;
            }
            return this.resultDeleteFiles;
        }

        Counter scannedDataManifests() {
            if (this.scannedDataManifestsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scannedDataManifestsBuildStage == 0) {
                this.scannedDataManifestsBuildStage = (byte)-1;
                this.scannedDataManifests = Objects.requireNonNull(ImmutableScanMetrics.super.scannedDataManifests(), "scannedDataManifests");
                this.scannedDataManifestsBuildStage = 1;
            }
            return this.scannedDataManifests;
        }

        Counter totalDataManifests() {
            if (this.totalDataManifestsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalDataManifestsBuildStage == 0) {
                this.totalDataManifestsBuildStage = (byte)-1;
                this.totalDataManifests = Objects.requireNonNull(ImmutableScanMetrics.super.totalDataManifests(), "totalDataManifests");
                this.totalDataManifestsBuildStage = 1;
            }
            return this.totalDataManifests;
        }

        Counter totalDeleteManifests() {
            if (this.totalDeleteManifestsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalDeleteManifestsBuildStage == 0) {
                this.totalDeleteManifestsBuildStage = (byte)-1;
                this.totalDeleteManifests = Objects.requireNonNull(ImmutableScanMetrics.super.totalDeleteManifests(), "totalDeleteManifests");
                this.totalDeleteManifestsBuildStage = 1;
            }
            return this.totalDeleteManifests;
        }

        Counter totalFileSizeInBytes() {
            if (this.totalFileSizeInBytesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalFileSizeInBytesBuildStage == 0) {
                this.totalFileSizeInBytesBuildStage = (byte)-1;
                this.totalFileSizeInBytes = Objects.requireNonNull(ImmutableScanMetrics.super.totalFileSizeInBytes(), "totalFileSizeInBytes");
                this.totalFileSizeInBytesBuildStage = 1;
            }
            return this.totalFileSizeInBytes;
        }

        Counter totalDeleteFileSizeInBytes() {
            if (this.totalDeleteFileSizeInBytesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalDeleteFileSizeInBytesBuildStage == 0) {
                this.totalDeleteFileSizeInBytesBuildStage = (byte)-1;
                this.totalDeleteFileSizeInBytes = Objects.requireNonNull(ImmutableScanMetrics.super.totalDeleteFileSizeInBytes(), "totalDeleteFileSizeInBytes");
                this.totalDeleteFileSizeInBytesBuildStage = 1;
            }
            return this.totalDeleteFileSizeInBytes;
        }

        Counter skippedDataManifests() {
            if (this.skippedDataManifestsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skippedDataManifestsBuildStage == 0) {
                this.skippedDataManifestsBuildStage = (byte)-1;
                this.skippedDataManifests = Objects.requireNonNull(ImmutableScanMetrics.super.skippedDataManifests(), "skippedDataManifests");
                this.skippedDataManifestsBuildStage = 1;
            }
            return this.skippedDataManifests;
        }

        Counter skippedDataFiles() {
            if (this.skippedDataFilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skippedDataFilesBuildStage == 0) {
                this.skippedDataFilesBuildStage = (byte)-1;
                this.skippedDataFiles = Objects.requireNonNull(ImmutableScanMetrics.super.skippedDataFiles(), "skippedDataFiles");
                this.skippedDataFilesBuildStage = 1;
            }
            return this.skippedDataFiles;
        }

        Counter skippedDeleteFiles() {
            if (this.skippedDeleteFilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skippedDeleteFilesBuildStage == 0) {
                this.skippedDeleteFilesBuildStage = (byte)-1;
                this.skippedDeleteFiles = Objects.requireNonNull(ImmutableScanMetrics.super.skippedDeleteFiles(), "skippedDeleteFiles");
                this.skippedDeleteFilesBuildStage = 1;
            }
            return this.skippedDeleteFiles;
        }

        Counter scannedDeleteManifests() {
            if (this.scannedDeleteManifestsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scannedDeleteManifestsBuildStage == 0) {
                this.scannedDeleteManifestsBuildStage = (byte)-1;
                this.scannedDeleteManifests = Objects.requireNonNull(ImmutableScanMetrics.super.scannedDeleteManifests(), "scannedDeleteManifests");
                this.scannedDeleteManifestsBuildStage = 1;
            }
            return this.scannedDeleteManifests;
        }

        Counter skippedDeleteManifests() {
            if (this.skippedDeleteManifestsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skippedDeleteManifestsBuildStage == 0) {
                this.skippedDeleteManifestsBuildStage = (byte)-1;
                this.skippedDeleteManifests = Objects.requireNonNull(ImmutableScanMetrics.super.skippedDeleteManifests(), "skippedDeleteManifests");
                this.skippedDeleteManifestsBuildStage = 1;
            }
            return this.skippedDeleteManifests;
        }

        Counter indexedDeleteFiles() {
            if (this.indexedDeleteFilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexedDeleteFilesBuildStage == 0) {
                this.indexedDeleteFilesBuildStage = (byte)-1;
                this.indexedDeleteFiles = Objects.requireNonNull(ImmutableScanMetrics.super.indexedDeleteFiles(), "indexedDeleteFiles");
                this.indexedDeleteFilesBuildStage = 1;
            }
            return this.indexedDeleteFiles;
        }

        Counter equalityDeleteFiles() {
            if (this.equalityDeleteFilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.equalityDeleteFilesBuildStage == 0) {
                this.equalityDeleteFilesBuildStage = (byte)-1;
                this.equalityDeleteFiles = Objects.requireNonNull(ImmutableScanMetrics.super.equalityDeleteFiles(), "equalityDeleteFiles");
                this.equalityDeleteFilesBuildStage = 1;
            }
            return this.equalityDeleteFiles;
        }

        Counter positionalDeleteFiles() {
            if (this.positionalDeleteFilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.positionalDeleteFilesBuildStage == 0) {
                this.positionalDeleteFilesBuildStage = (byte)-1;
                this.positionalDeleteFiles = Objects.requireNonNull(ImmutableScanMetrics.super.positionalDeleteFiles(), "positionalDeleteFiles");
                this.positionalDeleteFilesBuildStage = 1;
            }
            return this.positionalDeleteFiles;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.totalPlanningDurationBuildStage == -1) {
                attributes.add("totalPlanningDuration");
            }
            if (this.resultDataFilesBuildStage == -1) {
                attributes.add("resultDataFiles");
            }
            if (this.resultDeleteFilesBuildStage == -1) {
                attributes.add("resultDeleteFiles");
            }
            if (this.scannedDataManifestsBuildStage == -1) {
                attributes.add("scannedDataManifests");
            }
            if (this.totalDataManifestsBuildStage == -1) {
                attributes.add("totalDataManifests");
            }
            if (this.totalDeleteManifestsBuildStage == -1) {
                attributes.add("totalDeleteManifests");
            }
            if (this.totalFileSizeInBytesBuildStage == -1) {
                attributes.add("totalFileSizeInBytes");
            }
            if (this.totalDeleteFileSizeInBytesBuildStage == -1) {
                attributes.add("totalDeleteFileSizeInBytes");
            }
            if (this.skippedDataManifestsBuildStage == -1) {
                attributes.add("skippedDataManifests");
            }
            if (this.skippedDataFilesBuildStage == -1) {
                attributes.add("skippedDataFiles");
            }
            if (this.skippedDeleteFilesBuildStage == -1) {
                attributes.add("skippedDeleteFiles");
            }
            if (this.scannedDeleteManifestsBuildStage == -1) {
                attributes.add("scannedDeleteManifests");
            }
            if (this.skippedDeleteManifestsBuildStage == -1) {
                attributes.add("skippedDeleteManifests");
            }
            if (this.indexedDeleteFilesBuildStage == -1) {
                attributes.add("indexedDeleteFiles");
            }
            if (this.equalityDeleteFilesBuildStage == -1) {
                attributes.add("equalityDeleteFiles");
            }
            if (this.positionalDeleteFilesBuildStage == -1) {
                attributes.add("positionalDeleteFiles");
            }
            return "Cannot build ScanMetrics, attribute initializers form cycle " + attributes;
        }
    }
}

