/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2CredentialsWithRefresh;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;

public class OAuth2RefreshCredentialsHandler
implements OAuth2CredentialsWithRefresh.OAuth2RefreshHandler {
    private final Map<String, String> properties;

    private OAuth2RefreshCredentialsHandler(Map<String, String> properties) {
        Preconditions.checkArgument(null != properties.get("gcs.oauth2.refresh-credentials-endpoint"), "Invalid credentials endpoint: null");
        this.properties = properties;
    }

    public AccessToken refreshAccessToken() {
        LoadCredentialsResponse response;
        try (RESTClient client = this.httpClient();){
            response = client.get(this.properties.get("gcs.oauth2.refresh-credentials-endpoint"), null, LoadCredentialsResponse.class, OAuth2Util.authHeaders(this.properties.get("token")), ErrorHandlers.defaultErrorHandler());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List gcsCredentials = response.credentials().stream().filter(c -> c.prefix().startsWith("gs")).collect(Collectors.toList());
        Preconditions.checkState(!gcsCredentials.isEmpty(), "Invalid GCS Credentials: empty");
        Preconditions.checkState(gcsCredentials.size() == 1, "Invalid GCS Credentials: only one GCS credential should exist");
        Credential gcsCredential = (Credential)gcsCredentials.get(0);
        this.checkCredential(gcsCredential, "gcs.oauth2.token");
        this.checkCredential(gcsCredential, "gcs.oauth2.token-expires-at");
        String token = gcsCredential.config().get("gcs.oauth2.token");
        String expiresAt = gcsCredential.config().get("gcs.oauth2.token-expires-at");
        return new AccessToken(token, new Date(Long.parseLong(expiresAt)));
    }

    private void checkCredential(Credential gcsCredential, String gcsOauth2Token) {
        Preconditions.checkState(gcsCredential.config().containsKey(gcsOauth2Token), "Invalid GCS Credentials: %s not set", (Object)gcsOauth2Token);
    }

    public static OAuth2RefreshCredentialsHandler create(Map<String, String> properties) {
        return new OAuth2RefreshCredentialsHandler(properties);
    }

    private RESTClient httpClient() {
        return HTTPClient.builder(this.properties).uri(this.properties.get("gcs.oauth2.refresh-credentials-endpoint")).build();
    }
}

