/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Aggregate;
import org.apache.iceberg.expressions.Bound;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class BoundAggregate<T, C>
extends Aggregate<BoundTerm<T>>
implements Bound<C> {
    protected BoundAggregate(Expression.Operation op, BoundTerm<T> term) {
        super(op, term);
    }

    @Override
    public C eval(StructLike struct) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement eval(StructLike)");
    }

    C eval(DataFile file) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement eval(DataFile)");
    }

    boolean hasValue(DataFile file) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement hasValue(DataFile)");
    }

    Aggregator<C> newAggregator() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement newAggregator()");
    }

    @Override
    public BoundReference<?> ref() {
        return ((BoundTerm)this.term()).ref();
    }

    public Type type() {
        if (this.op() == Expression.Operation.COUNT || this.op() == Expression.Operation.COUNT_STAR) {
            return Types.LongType.get();
        }
        return ((BoundTerm)this.term()).type();
    }

    public String columnName() {
        if (this.op() == Expression.Operation.COUNT_STAR) {
            return "*";
        }
        return this.ref().name();
    }

    public String describe() {
        switch (this.op()) {
            case COUNT_STAR: {
                return "count(*)";
            }
            case COUNT: {
                return "count(" + ExpressionUtil.describe(this.term()) + ")";
            }
            case MAX: {
                return "max(" + ExpressionUtil.describe(this.term()) + ")";
            }
            case MIN: {
                return "min(" + ExpressionUtil.describe(this.term()) + ")";
            }
        }
        throw new UnsupportedOperationException("Unsupported aggregate type: " + this.op());
    }

    <V> boolean safeContainsKey(Map<Integer, V> map, int key) {
        if (map == null) {
            return false;
        }
        return map.containsKey(key);
    }

    <V> V safeGet(Map<Integer, V> map, int key) {
        return this.safeGet(map, key, null);
    }

    <V> V safeGet(Map<Integer, V> map, int key, V defaultValue) {
        if (map != null) {
            return map.getOrDefault(key, defaultValue);
        }
        return null;
    }

    static abstract class NullSafeAggregator<T, R>
    implements Aggregator<R> {
        private final BoundAggregate<T, R> aggregate;
        private boolean isValid = true;

        NullSafeAggregator(BoundAggregate<T, R> aggregate) {
            this.aggregate = aggregate;
        }

        protected abstract void update(R var1);

        protected abstract R current();

        @Override
        public void update(StructLike struct) {
            R value = this.aggregate.eval(struct);
            if (value != null) {
                this.update(value);
            }
        }

        @Override
        public boolean hasValue(DataFile file) {
            return this.aggregate.hasValue(file);
        }

        @Override
        public void update(DataFile file) {
            if (this.isValid) {
                if (this.hasValue(file)) {
                    R value = this.aggregate.eval(file);
                    if (value != null) {
                        this.update(value);
                    }
                } else {
                    this.isValid = false;
                }
            }
        }

        @Override
        public R result() {
            if (!this.isValid) {
                return null;
            }
            return this.current();
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }
    }

    static interface Aggregator<R> {
        public void update(StructLike var1);

        public void update(DataFile var1);

        public boolean hasValue(DataFile var1);

        public R result();

        public boolean isValid();
    }
}

