/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.types;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.types.ImmutableGenericRepositoryConfig;

@JsonSerialize(using=RepositoryConfigUnknownTypeSerializer.class)
@JsonDeserialize(using=RepositoryConfigUnknownTypeDeserializer.class)
@Value.Immutable
public abstract class GenericRepositoryConfig
implements RepositoryConfig {
    @Override
    @Value.Parameter(order=1)
    public abstract RepositoryConfig.Type getType();

    @javax.annotation.Nullable
    @Nullable
    @Schema(type=SchemaType.OBJECT)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonUnwrapped
    @Value.Parameter(order=3)
    public abstract Map<String, Object> getAttributes();

    public static GenericRepositoryConfig repositoryConfigUnknownType(final String type, Map<String, Object> all) {
        return ImmutableGenericRepositoryConfig.of(new RepositoryConfig.Type(){

            @Override
            public String name() {
                return type;
            }

            @Override
            public Class<? extends RepositoryConfig> type() {
                return GenericRepositoryConfig.class;
            }
        }, all);
    }

    static final class RepositoryConfigUnknownTypeDeserializer
    extends JsonDeserializer<GenericRepositoryConfig> {
        RepositoryConfigUnknownTypeDeserializer() {
        }

        @Override
        public GenericRepositoryConfig deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Map all = p.readValueAs(Map.class);
            Object type = all.remove("type");
            if (type == null) {
                type = "UNKNOWN_CONTENT_TYPE";
            }
            return GenericRepositoryConfig.repositoryConfigUnknownType(type.toString(), all);
        }
    }

    static final class RepositoryConfigUnknownTypeSerializer
    extends JsonSerializer<GenericRepositoryConfig> {
        RepositoryConfigUnknownTypeSerializer() {
        }

        @Override
        public void serializeWithType(GenericRepositoryConfig value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType().name());
            for (Map.Entry<String, Object> entry : value.getAttributes().entrySet()) {
                gen.writeFieldName(entry.getKey());
                gen.writeObject(entry.getValue());
            }
            gen.writeEndObject();
        }

        @Override
        public void serialize(GenericRepositoryConfig value, JsonGenerator gen, SerializerProvider serializers) {
            throw new UnsupportedOperationException();
        }
    }
}

