/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.ReferenceConflicts;

public class NessieReferenceConflictException
extends NessieConflictException {
    private final ReferenceConflicts referenceConflicts;

    public NessieReferenceConflictException(ReferenceConflicts referenceConflicts, String message, Throwable cause) {
        super(message, cause);
        this.referenceConflicts = referenceConflicts;
    }

    public NessieReferenceConflictException(String message, Throwable cause) {
        this(null, message, cause);
    }

    public NessieReferenceConflictException(String message) {
        super(message);
        this.referenceConflicts = null;
    }

    public NessieReferenceConflictException(NessieError error) {
        super(error);
        this.referenceConflicts = error.getErrorDetailsAsOrNull(ReferenceConflicts.class);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.REFERENCE_CONFLICT;
    }

    @Override
    public ReferenceConflicts getErrorDetails() {
        return this.referenceConflicts;
    }
}

