/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk8;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.http.impl.ResponseClosingInputStream;

final class UrlConnectionResponseContext
implements ResponseContext {
    private final HttpURLConnection connection;
    private final URI uri;
    private final Status status;
    private InputStream inputStream;

    UrlConnectionResponseContext(HttpURLConnection connection, URI uri, Status status) {
        this.connection = connection;
        this.uri = uri;
        this.status = status;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream base = this.safeGetInputStream();
        if (base == null) {
            return null;
        }
        if (this.inputStream == null) {
            this.inputStream = new ResponseClosingInputStream(this.maybeDecompress(base), this.connection::disconnect);
        }
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        return this.connection.getHeaderField("Content-Type");
    }

    @Override
    public URI getRequestedUri() {
        return this.uri;
    }

    @Override
    public void close(Exception error) {
        if (error != null) {
            try {
                InputStream base = this.safeGetInputStream();
                if (base != null) {
                    base.close();
                }
            }
            catch (Exception e) {
                error.addSuppressed(e);
            }
            finally {
                this.connection.disconnect();
            }
        }
    }

    private InputStream safeGetInputStream() throws IOException {
        try {
            return this.status.getCode() >= 400 ? this.connection.getErrorStream() : this.connection.getInputStream();
        }
        catch (IOException e) {
            this.connection.disconnect();
            throw e;
        }
    }

    private InputStream maybeDecompress(InputStream inputStream) throws IOException {
        String contentEncoding = this.connection.getHeaderField("Content-Encoding");
        if ("gzip".equals(contentEncoding)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equals(contentEncoding)) {
            return new InflaterInputStream(inputStream);
        }
        return inputStream;
    }
}

