/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.EnvironmentContext;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.catalog.BaseViewSessionCatalog;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableCommit;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileIOTracker;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.metrics.MetricsReporters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.Endpoint;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTMetricsReporter;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.RESTTableOperations;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.RESTViewOperations;
import org.apache.iceberg.rest.ResourcePaths;
import org.apache.iceberg.rest.auth.AuthConfig;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.ImmutableCreateViewRequest;
import org.apache.iceberg.rest.requests.ImmutableRegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.util.EnvironmentUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.ThreadPools;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.ImmutableSQLViewRepresentation;
import org.apache.iceberg.view.ImmutableViewVersion;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewUtil;
import org.apache.iceberg.view.ViewVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTSessionCatalog
extends BaseViewSessionCatalog
implements Configurable<Object>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RESTSessionCatalog.class);
    private static final String DEFAULT_FILE_IO_IMPL = "org.apache.iceberg.io.ResolvingFileIO";
    private static final String REST_METRICS_REPORTING_ENABLED = "rest-metrics-reporting-enabled";
    private static final String REST_SNAPSHOT_LOADING_MODE = "snapshot-loading-mode";
    static final String VIEW_ENDPOINTS_SUPPORTED = "view-endpoints-supported";
    public static final String REST_PAGE_SIZE = "rest-page-size";
    private static final List<String> TOKEN_PREFERENCE_ORDER = ImmutableList.of("urn:ietf:params:oauth:token-type:id_token", "urn:ietf:params:oauth:token-type:access_token", "urn:ietf:params:oauth:token-type:jwt", "urn:ietf:params:oauth:token-type:saml2", "urn:ietf:params:oauth:token-type:saml1");
    private static final Set<String> TABLE_SESSION_ALLOW_LIST = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("token")).addAll(TOKEN_PREFERENCE_ORDER)).build();
    private static final Set<Endpoint> DEFAULT_ENDPOINTS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Endpoint.V1_LIST_NAMESPACES)).add(Endpoint.V1_LOAD_NAMESPACE)).add(Endpoint.V1_CREATE_NAMESPACE)).add(Endpoint.V1_UPDATE_NAMESPACE)).add(Endpoint.V1_DELETE_NAMESPACE)).add(Endpoint.V1_LIST_TABLES)).add(Endpoint.V1_LOAD_TABLE)).add(Endpoint.V1_CREATE_TABLE)).add(Endpoint.V1_UPDATE_TABLE)).add(Endpoint.V1_DELETE_TABLE)).add(Endpoint.V1_RENAME_TABLE)).add(Endpoint.V1_REGISTER_TABLE)).add(Endpoint.V1_REPORT_METRICS)).build();
    private static final Set<Endpoint> VIEW_ENDPOINTS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Endpoint.V1_LIST_VIEWS)).add(Endpoint.V1_LOAD_VIEW)).add(Endpoint.V1_CREATE_VIEW)).add(Endpoint.V1_UPDATE_VIEW)).add(Endpoint.V1_DELETE_VIEW)).add(Endpoint.V1_RENAME_VIEW)).build();
    private final Function<Map<String, String>, RESTClient> clientBuilder;
    private final BiFunction<SessionCatalog.SessionContext, Map<String, String>, FileIO> ioBuilder;
    private Cache<String, OAuth2Util.AuthSession> sessions = null;
    private Cache<String, OAuth2Util.AuthSession> tableSessions = null;
    private FileIOTracker fileIOTracker = null;
    private OAuth2Util.AuthSession catalogAuth = null;
    private boolean keepTokenRefreshed = true;
    private RESTClient client = null;
    private ResourcePaths paths = null;
    private SnapshotMode snapshotMode = null;
    private Object conf = null;
    private FileIO io = null;
    private MetricsReporter reporter = null;
    private boolean reportingViaRestEnabled;
    private Integer pageSize = null;
    private CloseableGroup closeables = null;
    private Set<Endpoint> endpoints;
    private volatile ScheduledExecutorService refreshExecutor = null;

    public RESTSessionCatalog() {
        this(config -> HTTPClient.builder(config).uri((String)config.get("uri")).build(), null);
    }

    public RESTSessionCatalog(Function<Map<String, String>, RESTClient> clientBuilder, BiFunction<SessionCatalog.SessionContext, Map<String, String>, FileIO> ioBuilder) {
        Preconditions.checkNotNull(clientBuilder, "Invalid client builder: null");
        this.clientBuilder = clientBuilder;
        this.ioBuilder = ioBuilder;
    }

    @Override
    public void initialize(String name, Map<String, String> unresolved) {
        ConfigResponse config;
        OAuthTokenResponse authResponse;
        Preconditions.checkArgument(unresolved != null, "Invalid configuration: null");
        Map<String, String> props = EnvironmentUtil.resolveAll(unresolved);
        long startTimeMillis = System.currentTimeMillis();
        String initToken = props.get("token");
        boolean hasInitToken = initToken != null;
        String credential = props.get("credential");
        boolean hasCredential = credential != null && !credential.isEmpty();
        String scope = props.getOrDefault("scope", "catalog");
        Map<String, String> optionalOAuthParams = OAuth2Util.buildOptionalParam(props);
        if (!props.containsKey("oauth2-server-uri") && (hasInitToken || hasCredential) && !PropertyUtil.propertyAsBoolean(props, "rest.sigv4-enabled", false)) {
            LOG.warn("Iceberg REST client is missing the OAuth2 server URI configuration and defaults to {}{}. This automatic fallback will be removed in a future Iceberg release.It is recommended to configure the OAuth2 endpoint using the '{}' property to be prepared. This warning will disappear if the OAuth2 endpoint is explicitly configured. See https://github.com/apache/iceberg/issues/10537", new Object[]{props.get("uri"), ResourcePaths.tokens(), "oauth2-server-uri"});
        }
        String oauth2ServerUri = props.getOrDefault("oauth2-server-uri", ResourcePaths.tokens());
        try (RESTClient initClient = this.clientBuilder.apply(props);){
            Map<String, String> initHeaders = RESTUtil.merge(RESTSessionCatalog.configHeaders(props), OAuth2Util.authHeaders(initToken));
            if (hasCredential) {
                authResponse = OAuth2Util.fetchToken(initClient, initHeaders, credential, scope, oauth2ServerUri, optionalOAuthParams);
                Map<String, String> authHeaders = RESTUtil.merge(initHeaders, OAuth2Util.authHeaders(authResponse.token()));
                config = RESTSessionCatalog.fetchConfig(initClient, authHeaders, props);
            } else {
                authResponse = null;
                config = RESTSessionCatalog.fetchConfig(initClient, initHeaders, props);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close HTTP client", e);
        }
        Map<String, String> mergedProps = config.merge(props);
        Map<String, String> baseHeaders = RESTSessionCatalog.configHeaders(mergedProps);
        this.endpoints = config.endpoints().isEmpty() ? (PropertyUtil.propertyAsBoolean(mergedProps, VIEW_ENDPOINTS_SUPPORTED, false) ? ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(DEFAULT_ENDPOINTS)).addAll(VIEW_ENDPOINTS)).build() : DEFAULT_ENDPOINTS) : ImmutableSet.copyOf(config.endpoints());
        this.sessions = RESTSessionCatalog.newSessionCache(mergedProps);
        this.tableSessions = RESTSessionCatalog.newSessionCache(mergedProps);
        this.keepTokenRefreshed = PropertyUtil.propertyAsBoolean(mergedProps, "token-refresh-enabled", true);
        this.client = this.clientBuilder.apply(mergedProps);
        this.paths = ResourcePaths.forCatalogProperties(mergedProps);
        String token = mergedProps.get("token");
        this.catalogAuth = new OAuth2Util.AuthSession(baseHeaders, AuthConfig.builder().credential(credential).scope(scope).oauth2ServerUri(oauth2ServerUri).optionalOAuthParams(optionalOAuthParams).build());
        if (authResponse != null) {
            this.catalogAuth = OAuth2Util.AuthSession.fromTokenResponse(this.client, this.tokenRefreshExecutor(name), authResponse, startTimeMillis, this.catalogAuth);
        } else if (token != null) {
            this.catalogAuth = OAuth2Util.AuthSession.fromAccessToken(this.client, this.tokenRefreshExecutor(name), token, this.expiresAtMillis(mergedProps), this.catalogAuth);
        }
        this.pageSize = PropertyUtil.propertyAsNullableInt(mergedProps, REST_PAGE_SIZE);
        if (this.pageSize != null) {
            Preconditions.checkArgument(this.pageSize > 0, "Invalid value for %s, must be a positive integer", (Object)REST_PAGE_SIZE);
        }
        this.io = this.newFileIO(SessionCatalog.SessionContext.createEmpty(), mergedProps);
        this.fileIOTracker = new FileIOTracker();
        this.closeables = new CloseableGroup();
        this.closeables.addCloseable(this.io);
        this.closeables.addCloseable(this.client);
        this.closeables.addCloseable(this.fileIOTracker);
        this.closeables.setSuppressCloseFailure(true);
        this.snapshotMode = SnapshotMode.valueOf(PropertyUtil.propertyAsString(mergedProps, REST_SNAPSHOT_LOADING_MODE, SnapshotMode.ALL.name()).toUpperCase(Locale.US));
        this.reporter = CatalogUtil.loadMetricsReporter(mergedProps);
        this.reportingViaRestEnabled = PropertyUtil.propertyAsBoolean(mergedProps, REST_METRICS_REPORTING_ENABLED, true);
        super.initialize(name, mergedProps);
    }

    private OAuth2Util.AuthSession session(SessionCatalog.SessionContext context) {
        OAuth2Util.AuthSession session = this.sessions.get(context.sessionId(), id -> {
            Pair<String, Supplier<OAuth2Util.AuthSession>> newSession = this.newSession(context.credentials(), context.properties(), this.catalogAuth);
            if (null != newSession) {
                return newSession.second().get();
            }
            return null;
        });
        return session != null ? session : this.catalogAuth;
    }

    private Supplier<Map<String, String>> headers(SessionCatalog.SessionContext context) {
        return this.session(context)::headers;
    }

    @Override
    public void setConf(Object newConf) {
        this.conf = newConf;
    }

    @Override
    public List<TableIdentifier> listTables(SessionCatalog.SessionContext context, Namespace ns) {
        if (!this.endpoints.contains(Endpoint.V1_LIST_TABLES)) {
            return ImmutableList.of();
        }
        this.checkNamespaceIsValid(ns);
        HashMap<String, String> queryParams = Maps.newHashMap();
        ImmutableList.Builder tables = ImmutableList.builder();
        String pageToken = "";
        if (this.pageSize != null) {
            queryParams.put("pageSize", String.valueOf(this.pageSize));
        }
        do {
            queryParams.put("pageToken", pageToken);
            ListTablesResponse response = this.client.get(this.paths.tables(ns), queryParams, ListTablesResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
            pageToken = response.nextPageToken();
            tables.addAll(response.identifiers());
        } while (pageToken != null);
        return tables.build();
    }

    @Override
    public boolean dropTable(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        Endpoint.check(this.endpoints, Endpoint.V1_DELETE_TABLE);
        this.checkIdentifierIsValid(identifier);
        try {
            this.client.delete(this.paths.table(identifier), null, this.headers(context), ErrorHandlers.tableErrorHandler());
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    @Override
    public boolean purgeTable(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        Endpoint.check(this.endpoints, Endpoint.V1_DELETE_TABLE);
        this.checkIdentifierIsValid(identifier);
        try {
            this.client.delete(this.paths.table(identifier), ImmutableMap.of("purgeRequested", "true"), null, this.headers(context), ErrorHandlers.tableErrorHandler());
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    @Override
    public void renameTable(SessionCatalog.SessionContext context, TableIdentifier from, TableIdentifier to) {
        Endpoint.check(this.endpoints, Endpoint.V1_RENAME_TABLE);
        this.checkIdentifierIsValid(from);
        this.checkIdentifierIsValid(to);
        RenameTableRequest request = RenameTableRequest.builder().withSource(from).withDestination(to).build();
        this.client.post(this.paths.rename(), (RESTRequest)request, null, this.headers(context), ErrorHandlers.tableErrorHandler());
    }

    private LoadTableResponse loadInternal(SessionCatalog.SessionContext context, TableIdentifier identifier, SnapshotMode mode) {
        Endpoint.check(this.endpoints, Endpoint.V1_LOAD_TABLE);
        return this.client.get(this.paths.table(identifier), mode.params(), LoadTableResponse.class, this.headers(context), ErrorHandlers.tableErrorHandler());
    }

    @Override
    public Table loadTable(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        MetadataTableType metadataType;
        TableIdentifier loadedIdent;
        LoadTableResponse response;
        Endpoint.check(this.endpoints, Endpoint.V1_LOAD_TABLE, () -> new NoSuchTableException("Unable to load table %s.%s: Server does not support endpoint %s", this.name(), identifier, Endpoint.V1_LOAD_TABLE));
        this.checkIdentifierIsValid(identifier);
        try {
            response = this.loadInternal(context, identifier, this.snapshotMode);
            loadedIdent = identifier;
            metadataType = null;
        }
        catch (NoSuchTableException original) {
            metadataType = MetadataTableType.from(identifier.name());
            if (metadataType != null) {
                TableIdentifier baseIdent = TableIdentifier.of(identifier.namespace().levels());
                try {
                    response = this.loadInternal(context, baseIdent, this.snapshotMode);
                    loadedIdent = baseIdent;
                }
                catch (NoSuchTableException ignored) {
                    throw original;
                }
            }
            throw original;
        }
        TableIdentifier finalIdentifier = loadedIdent;
        OAuth2Util.AuthSession session = this.tableSession(response.config(), this.session(context));
        TableMetadata tableMetadata = this.snapshotMode == SnapshotMode.REFS ? TableMetadata.buildFrom(response.tableMetadata()).withMetadataLocation(response.metadataLocation()).setPreviousFileLocation(null).setSnapshotsSupplier(() -> this.loadInternal(context, finalIdentifier, SnapshotMode.ALL).tableMetadata().snapshots()).discardChanges().build() : response.tableMetadata();
        RESTTableOperations ops = new RESTTableOperations(this.client, this.paths.table(finalIdentifier), session::headers, this.tableFileIO(context, response.config()), tableMetadata, this.endpoints);
        this.trackFileIO(ops);
        BaseTable table = new BaseTable(ops, this.fullTableName(finalIdentifier), this.metricsReporter(this.paths.metrics(finalIdentifier), session::headers));
        if (metadataType != null) {
            return MetadataTableUtils.createMetadataTableInstance(table, metadataType);
        }
        return table;
    }

    private void trackFileIO(RESTTableOperations ops) {
        if (this.io != ops.io()) {
            this.fileIOTracker.track(ops);
        }
    }

    private MetricsReporter metricsReporter(String metricsEndpoint, Supplier<Map<String, String>> headers) {
        if (this.reportingViaRestEnabled && this.endpoints.contains(Endpoint.V1_REPORT_METRICS)) {
            RESTMetricsReporter restMetricsReporter = new RESTMetricsReporter(this.client, metricsEndpoint, headers);
            return MetricsReporters.combine(this.reporter, restMetricsReporter);
        }
        return this.reporter;
    }

    @Override
    public Catalog.TableBuilder buildTable(SessionCatalog.SessionContext context, TableIdentifier identifier, Schema schema) {
        return new Builder(identifier, schema, context);
    }

    @Override
    public void invalidateTable(SessionCatalog.SessionContext context, TableIdentifier ident) {
    }

    @Override
    public Table registerTable(SessionCatalog.SessionContext context, TableIdentifier ident, String metadataFileLocation) {
        Endpoint.check(this.endpoints, Endpoint.V1_REGISTER_TABLE);
        this.checkIdentifierIsValid(ident);
        Preconditions.checkArgument(metadataFileLocation != null && !metadataFileLocation.isEmpty(), "Invalid metadata file location: %s", (Object)metadataFileLocation);
        ImmutableRegisterTableRequest request = ImmutableRegisterTableRequest.builder().name(ident.name()).metadataLocation(metadataFileLocation).build();
        LoadTableResponse response = this.client.post(this.paths.register(ident.namespace()), (RESTRequest)request, LoadTableResponse.class, this.headers(context), ErrorHandlers.tableErrorHandler());
        OAuth2Util.AuthSession session = this.tableSession(response.config(), this.session(context));
        RESTTableOperations ops = new RESTTableOperations(this.client, this.paths.table(ident), session::headers, this.tableFileIO(context, response.config()), response.tableMetadata(), this.endpoints);
        this.trackFileIO(ops);
        return new BaseTable(ops, this.fullTableName(ident), this.metricsReporter(this.paths.metrics(ident), session::headers));
    }

    @Override
    public void createNamespace(SessionCatalog.SessionContext context, Namespace namespace, Map<String, String> metadata) {
        Endpoint.check(this.endpoints, Endpoint.V1_CREATE_NAMESPACE);
        CreateNamespaceRequest request = CreateNamespaceRequest.builder().withNamespace(namespace).setProperties(metadata).build();
        this.client.post(this.paths.namespaces(), (RESTRequest)request, CreateNamespaceResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
    }

    @Override
    public List<Namespace> listNamespaces(SessionCatalog.SessionContext context, Namespace namespace) {
        if (!this.endpoints.contains(Endpoint.V1_LIST_NAMESPACES)) {
            return ImmutableList.of();
        }
        HashMap<String, String> queryParams = Maps.newHashMap();
        if (!namespace.isEmpty()) {
            queryParams.put("parent", RESTUtil.encodeNamespace(namespace));
        }
        ImmutableList.Builder namespaces = ImmutableList.builder();
        String pageToken = "";
        if (this.pageSize != null) {
            queryParams.put("pageSize", String.valueOf(this.pageSize));
        }
        do {
            queryParams.put("pageToken", pageToken);
            ListNamespacesResponse response = this.client.get(this.paths.namespaces(), queryParams, ListNamespacesResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
            pageToken = response.nextPageToken();
            namespaces.addAll(response.namespaces());
        } while (pageToken != null);
        return namespaces.build();
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(SessionCatalog.SessionContext context, Namespace ns) {
        Endpoint.check(this.endpoints, Endpoint.V1_LOAD_NAMESPACE);
        this.checkNamespaceIsValid(ns);
        GetNamespaceResponse response = this.client.get(this.paths.namespace(ns), GetNamespaceResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
        return response.properties();
    }

    @Override
    public boolean dropNamespace(SessionCatalog.SessionContext context, Namespace ns) {
        Endpoint.check(this.endpoints, Endpoint.V1_DELETE_NAMESPACE);
        this.checkNamespaceIsValid(ns);
        try {
            this.client.delete(this.paths.namespace(ns), null, this.headers(context), ErrorHandlers.namespaceErrorHandler());
            return true;
        }
        catch (NoSuchNamespaceException e) {
            return false;
        }
    }

    @Override
    public boolean updateNamespaceMetadata(SessionCatalog.SessionContext context, Namespace ns, Map<String, String> updates, Set<String> removals) {
        Endpoint.check(this.endpoints, Endpoint.V1_UPDATE_NAMESPACE);
        this.checkNamespaceIsValid(ns);
        UpdateNamespacePropertiesRequest request = UpdateNamespacePropertiesRequest.builder().updateAll(updates).removeAll(removals).build();
        UpdateNamespacePropertiesResponse response = this.client.post(this.paths.namespaceProperties(ns), (RESTRequest)request, UpdateNamespacePropertiesResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
        return !response.updated().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService tokenRefreshExecutor(String catalogName) {
        if (!this.keepTokenRefreshed) {
            return null;
        }
        if (this.refreshExecutor == null) {
            RESTSessionCatalog rESTSessionCatalog = this;
            synchronized (rESTSessionCatalog) {
                if (this.refreshExecutor == null) {
                    this.refreshExecutor = ThreadPools.newScheduledPool(catalogName + "-token-refresh", 1);
                }
            }
        }
        return this.refreshExecutor;
    }

    @Override
    public void close() throws IOException {
        this.shutdownRefreshExecutor();
        if (this.closeables != null) {
            this.closeables.close();
        }
    }

    private void shutdownRefreshExecutor() {
        if (this.refreshExecutor != null) {
            ScheduledExecutorService service = this.refreshExecutor;
            this.refreshExecutor = null;
            List<Runnable> tasks = service.shutdownNow();
            tasks.forEach(task -> {
                if (task instanceof Future) {
                    ((Future)((Object)task)).cancel(true);
                }
            });
            try {
                if (!service.awaitTermination(1L, TimeUnit.MINUTES)) {
                    LOG.warn("Timed out waiting for refresh executor to terminate");
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for refresh executor to terminate", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static List<MetadataUpdate> createChanges(TableMetadata meta) {
        Map<String, String> properties;
        ImmutableList.Builder changes = ImmutableList.builder();
        changes.add(new MetadataUpdate.AssignUUID(meta.uuid()));
        changes.add(new MetadataUpdate.UpgradeFormatVersion(meta.formatVersion()));
        Schema schema = meta.schema();
        changes.add(new MetadataUpdate.AddSchema(schema, schema.highestFieldId()));
        changes.add(new MetadataUpdate.SetCurrentSchema(-1));
        PartitionSpec spec = meta.spec();
        if (spec != null && spec.isPartitioned()) {
            changes.add(new MetadataUpdate.AddPartitionSpec(spec));
        } else {
            changes.add(new MetadataUpdate.AddPartitionSpec(PartitionSpec.unpartitioned()));
        }
        changes.add(new MetadataUpdate.SetDefaultPartitionSpec(-1));
        SortOrder order = meta.sortOrder();
        if (order != null && order.isSorted()) {
            changes.add(new MetadataUpdate.AddSortOrder(order));
        } else {
            changes.add(new MetadataUpdate.AddSortOrder(SortOrder.unsorted()));
        }
        changes.add(new MetadataUpdate.SetDefaultSortOrder(-1));
        String location = meta.location();
        if (location != null) {
            changes.add(new MetadataUpdate.SetLocation(location));
        }
        if ((properties = meta.properties()) != null && !properties.isEmpty()) {
            changes.add(new MetadataUpdate.SetProperties(properties));
        }
        return changes.build();
    }

    private String fullTableName(TableIdentifier ident) {
        return String.format("%s.%s", this.name(), ident);
    }

    private FileIO newFileIO(SessionCatalog.SessionContext context, Map<String, String> properties) {
        if (null != this.ioBuilder) {
            return this.ioBuilder.apply(context, properties);
        }
        String ioImpl = properties.getOrDefault("io-impl", DEFAULT_FILE_IO_IMPL);
        return CatalogUtil.loadFileIO(ioImpl, properties, this.conf);
    }

    private FileIO tableFileIO(SessionCatalog.SessionContext context, Map<String, String> config) {
        if (config.isEmpty() && this.ioBuilder == null) {
            return this.io;
        }
        Map<String, String> fullConf = RESTUtil.merge(this.properties(), config);
        return this.newFileIO(context, fullConf);
    }

    private OAuth2Util.AuthSession tableSession(Map<String, String> tableConf, OAuth2Util.AuthSession parent) {
        HashMap<String, String> credentials = Maps.newHashMapWithExpectedSize(tableConf.size());
        for (String prop : tableConf.keySet()) {
            if (!TABLE_SESSION_ALLOW_LIST.contains(prop)) continue;
            credentials.put(prop, tableConf.get(prop));
        }
        Pair<String, Supplier<OAuth2Util.AuthSession>> newSession = this.newSession(credentials, tableConf, parent);
        if (null == newSession) {
            return parent;
        }
        OAuth2Util.AuthSession session = this.tableSessions.get(newSession.first(), id -> (OAuth2Util.AuthSession)((Supplier)newSession.second()).get());
        return session != null ? session : parent;
    }

    private static ConfigResponse fetchConfig(RESTClient client, Map<String, String> headers, Map<String, String> properties) {
        ImmutableMap.Builder<String, String> queryParams = ImmutableMap.builder();
        if (properties.containsKey("warehouse")) {
            queryParams.put("warehouse", properties.get("warehouse"));
        }
        ConfigResponse configResponse = client.get(ResourcePaths.config(), queryParams.build(), ConfigResponse.class, headers, ErrorHandlers.defaultErrorHandler());
        configResponse.validate();
        return configResponse;
    }

    private Pair<String, Supplier<OAuth2Util.AuthSession>> newSession(Map<String, String> credentials, Map<String, String> properties, OAuth2Util.AuthSession parent) {
        if (credentials != null) {
            if (credentials.containsKey("token")) {
                return Pair.of(credentials.get("token"), () -> OAuth2Util.AuthSession.fromAccessToken(this.client, this.tokenRefreshExecutor(this.name()), (String)credentials.get("token"), this.expiresAtMillis(properties), parent));
            }
            if (credentials.containsKey("credential")) {
                return Pair.of(credentials.get("credential"), () -> OAuth2Util.AuthSession.fromCredential(this.client, this.tokenRefreshExecutor(this.name()), (String)credentials.get("credential"), parent));
            }
            for (String tokenType : TOKEN_PREFERENCE_ORDER) {
                if (!credentials.containsKey(tokenType)) continue;
                return Pair.of(credentials.get(tokenType), () -> OAuth2Util.AuthSession.fromTokenExchange(this.client, this.tokenRefreshExecutor(this.name()), (String)credentials.get(tokenType), tokenType, parent));
            }
        }
        return null;
    }

    private Long expiresAtMillis(Map<String, String> properties) {
        if (properties.containsKey("token-expires-in-ms")) {
            long expiresInMillis = PropertyUtil.propertyAsLong(properties, "token-expires-in-ms", 3600000L);
            return System.currentTimeMillis() + expiresInMillis;
        }
        return null;
    }

    private void checkIdentifierIsValid(TableIdentifier tableIdentifier) {
        if (tableIdentifier.namespace().isEmpty()) {
            throw new NoSuchTableException("Invalid table identifier: %s", tableIdentifier);
        }
    }

    private void checkViewIdentifierIsValid(TableIdentifier identifier) {
        if (identifier.namespace().isEmpty()) {
            throw new NoSuchViewException("Invalid view identifier: %s", identifier);
        }
    }

    private void checkNamespaceIsValid(Namespace namespace) {
        if (namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Invalid namespace: %s", namespace);
        }
    }

    private static Map<String, String> configHeaders(Map<String, String> properties) {
        return RESTUtil.extractPrefixMap(properties, "header.");
    }

    private static Cache<String, OAuth2Util.AuthSession> newSessionCache(Map<String, String> properties) {
        long expirationIntervalMs = PropertyUtil.propertyAsLong(properties, "auth.session-timeout-ms", CatalogProperties.AUTH_SESSION_TIMEOUT_MS_DEFAULT);
        return Caffeine.newBuilder().expireAfterAccess(Duration.ofMillis(expirationIntervalMs)).removalListener((id, auth, cause) -> {
            if (auth != null) {
                auth.stopRefreshing();
            }
        }).build();
    }

    public void commitTransaction(SessionCatalog.SessionContext context, List<TableCommit> commits) {
        Endpoint.check(this.endpoints, Endpoint.V1_COMMIT_TRANSACTION);
        ArrayList<UpdateTableRequest> tableChanges = Lists.newArrayListWithCapacity(commits.size());
        for (TableCommit commit : commits) {
            tableChanges.add(UpdateTableRequest.create(commit.identifier(), commit.requirements(), commit.updates()));
        }
        this.client.post(this.paths.commitTransaction(), (RESTRequest)new CommitTransactionRequest(tableChanges), null, this.headers(context), ErrorHandlers.tableCommitHandler());
    }

    @Override
    public List<TableIdentifier> listViews(SessionCatalog.SessionContext context, Namespace namespace) {
        if (!this.endpoints.contains(Endpoint.V1_LIST_VIEWS)) {
            return ImmutableList.of();
        }
        this.checkNamespaceIsValid(namespace);
        HashMap<String, String> queryParams = Maps.newHashMap();
        ImmutableList.Builder views = ImmutableList.builder();
        String pageToken = "";
        if (this.pageSize != null) {
            queryParams.put("pageSize", String.valueOf(this.pageSize));
        }
        do {
            queryParams.put("pageToken", pageToken);
            ListTablesResponse response = this.client.get(this.paths.views(namespace), queryParams, ListTablesResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
            pageToken = response.nextPageToken();
            views.addAll(response.identifiers());
        } while (pageToken != null);
        return views.build();
    }

    @Override
    public View loadView(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        Endpoint.check(this.endpoints, Endpoint.V1_LOAD_VIEW, () -> new NoSuchViewException("Unable to load view %s.%s: Server does not support endpoint %s", this.name(), identifier, Endpoint.V1_LOAD_VIEW));
        this.checkViewIdentifierIsValid(identifier);
        LoadViewResponse response = this.client.get(this.paths.view(identifier), LoadViewResponse.class, this.headers(context), ErrorHandlers.viewErrorHandler());
        OAuth2Util.AuthSession session = this.tableSession(response.config(), this.session(context));
        ViewMetadata metadata = response.metadata();
        RESTViewOperations ops = new RESTViewOperations(this.client, this.paths.view(identifier), session::headers, metadata, this.endpoints);
        return new BaseView(ops, ViewUtil.fullViewName(this.name(), identifier));
    }

    @Override
    public RESTViewBuilder buildView(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        return new RESTViewBuilder(context, identifier);
    }

    @Override
    public boolean dropView(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        Endpoint.check(this.endpoints, Endpoint.V1_DELETE_VIEW);
        this.checkViewIdentifierIsValid(identifier);
        try {
            this.client.delete(this.paths.view(identifier), null, this.headers(context), ErrorHandlers.viewErrorHandler());
            return true;
        }
        catch (NoSuchViewException e) {
            return false;
        }
    }

    @Override
    public void renameView(SessionCatalog.SessionContext context, TableIdentifier from, TableIdentifier to) {
        Endpoint.check(this.endpoints, Endpoint.V1_RENAME_VIEW);
        this.checkViewIdentifierIsValid(from);
        this.checkViewIdentifierIsValid(to);
        RenameTableRequest request = RenameTableRequest.builder().withSource(from).withDestination(to).build();
        this.client.post(this.paths.renameView(), (RESTRequest)request, null, this.headers(context), ErrorHandlers.viewErrorHandler());
    }

    private class RESTViewBuilder
    implements ViewBuilder {
        private final SessionCatalog.SessionContext context;
        private final TableIdentifier identifier;
        private final Map<String, String> properties = Maps.newHashMap();
        private final List<ViewRepresentation> representations = Lists.newArrayList();
        private Namespace defaultNamespace = null;
        private String defaultCatalog = null;
        private Schema schema = null;
        private String location = null;

        private RESTViewBuilder(SessionCatalog.SessionContext context, TableIdentifier identifier) {
            RESTSessionCatalog.this.checkViewIdentifierIsValid(identifier);
            this.identifier = identifier;
            this.context = context;
        }

        @Override
        public ViewBuilder withSchema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        @Override
        public ViewBuilder withQuery(String dialect, String sql) {
            this.representations.add(ImmutableSQLViewRepresentation.builder().dialect(dialect).sql(sql).build());
            return this;
        }

        @Override
        public ViewBuilder withDefaultCatalog(String catalog) {
            this.defaultCatalog = catalog;
            return this;
        }

        @Override
        public ViewBuilder withDefaultNamespace(Namespace namespace) {
            this.defaultNamespace = namespace;
            return this;
        }

        @Override
        public ViewBuilder withProperties(Map<String, String> newProperties) {
            this.properties.putAll(newProperties);
            return this;
        }

        @Override
        public ViewBuilder withProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        @Override
        public ViewBuilder withLocation(String newLocation) {
            this.location = newLocation;
            return this;
        }

        @Override
        public View create() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_CREATE_VIEW);
            Preconditions.checkState(!this.representations.isEmpty(), "Cannot create view without specifying a query");
            Preconditions.checkState(null != this.schema, "Cannot create view without specifying schema");
            Preconditions.checkState(null != this.defaultNamespace, "Cannot create view without specifying a default namespace");
            ImmutableViewVersion viewVersion = ImmutableViewVersion.builder().versionId(1).schemaId(this.schema.schemaId()).addAllRepresentations(this.representations).defaultNamespace(this.defaultNamespace).defaultCatalog(this.defaultCatalog).timestampMillis(System.currentTimeMillis()).putAllSummary(EnvironmentContext.get()).build();
            ImmutableCreateViewRequest request = ImmutableCreateViewRequest.builder().name(this.identifier.name()).location(this.location).schema(this.schema).viewVersion(viewVersion).properties(this.properties).build();
            LoadViewResponse response = RESTSessionCatalog.this.client.post(RESTSessionCatalog.this.paths.views(this.identifier.namespace()), (RESTRequest)request, LoadViewResponse.class, RESTSessionCatalog.this.headers(this.context), ErrorHandlers.viewErrorHandler());
            OAuth2Util.AuthSession session = RESTSessionCatalog.this.tableSession(response.config(), RESTSessionCatalog.this.session(this.context));
            RESTViewOperations ops = new RESTViewOperations(RESTSessionCatalog.this.client, RESTSessionCatalog.this.paths.view(this.identifier), session::headers, response.metadata(), RESTSessionCatalog.this.endpoints);
            return new BaseView(ops, ViewUtil.fullViewName(RESTSessionCatalog.this.name(), this.identifier));
        }

        @Override
        public View createOrReplace() {
            try {
                return this.replace(this.loadView());
            }
            catch (NoSuchViewException e) {
                return this.create();
            }
        }

        @Override
        public View replace() {
            if (RESTSessionCatalog.this.tableExists(this.context, this.identifier)) {
                throw new AlreadyExistsException("Table with same name already exists: %s", this.identifier);
            }
            return this.replace(this.loadView());
        }

        private LoadViewResponse loadView() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_LOAD_VIEW, () -> new NoSuchViewException("Unable to load view %s.%s: Server does not support endpoint %s", RESTSessionCatalog.this.name(), this.identifier, Endpoint.V1_LOAD_VIEW));
            return RESTSessionCatalog.this.client.get(RESTSessionCatalog.this.paths.view(this.identifier), LoadViewResponse.class, RESTSessionCatalog.this.headers(this.context), ErrorHandlers.viewErrorHandler());
        }

        private View replace(LoadViewResponse response) {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_UPDATE_VIEW);
            Preconditions.checkState(!this.representations.isEmpty(), "Cannot replace view without specifying a query");
            Preconditions.checkState(null != this.schema, "Cannot replace view without specifying schema");
            Preconditions.checkState(null != this.defaultNamespace, "Cannot replace view without specifying a default namespace");
            ViewMetadata metadata = response.metadata();
            int maxVersionId = metadata.versions().stream().map(ViewVersion::versionId).max(Integer::compareTo).orElseGet(metadata::currentVersionId);
            ImmutableViewVersion viewVersion = ImmutableViewVersion.builder().versionId(maxVersionId + 1).schemaId(this.schema.schemaId()).addAllRepresentations(this.representations).defaultNamespace(this.defaultNamespace).defaultCatalog(this.defaultCatalog).timestampMillis(System.currentTimeMillis()).putAllSummary(EnvironmentContext.get()).build();
            ViewMetadata.Builder builder = ViewMetadata.buildFrom(metadata).setProperties(this.properties).setCurrentVersion(viewVersion, this.schema);
            if (null != this.location) {
                builder.setLocation(this.location);
            }
            ViewMetadata replacement = builder.build();
            OAuth2Util.AuthSession session = RESTSessionCatalog.this.tableSession(response.config(), RESTSessionCatalog.this.session(this.context));
            RESTViewOperations ops = new RESTViewOperations(RESTSessionCatalog.this.client, RESTSessionCatalog.this.paths.view(this.identifier), session::headers, metadata, RESTSessionCatalog.this.endpoints);
            ops.commit(metadata, replacement);
            return new BaseView(ops, ViewUtil.fullViewName(RESTSessionCatalog.this.name(), this.identifier));
        }
    }

    private class Builder
    implements Catalog.TableBuilder {
        private final TableIdentifier ident;
        private final Schema schema;
        private final SessionCatalog.SessionContext context;
        private final ImmutableMap.Builder<String, String> propertiesBuilder = ImmutableMap.builder();
        private PartitionSpec spec = null;
        private SortOrder writeOrder = null;
        private String location = null;

        private Builder(TableIdentifier ident, Schema schema, SessionCatalog.SessionContext context) {
            RESTSessionCatalog.this.checkIdentifierIsValid(ident);
            this.ident = ident;
            this.schema = schema;
            this.context = context;
        }

        @Override
        public Builder withPartitionSpec(PartitionSpec tableSpec) {
            this.spec = tableSpec;
            return this;
        }

        @Override
        public Builder withSortOrder(SortOrder tableWriteOrder) {
            this.writeOrder = tableWriteOrder;
            return this;
        }

        @Override
        public Builder withLocation(String tableLocation) {
            this.location = tableLocation;
            return this;
        }

        @Override
        public Builder withProperties(Map<String, String> props) {
            if (props != null) {
                this.propertiesBuilder.putAll(props);
            }
            return this;
        }

        @Override
        public Builder withProperty(String key, String value) {
            this.propertiesBuilder.put(key, value);
            return this;
        }

        @Override
        public Table create() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_CREATE_TABLE);
            CreateTableRequest request = CreateTableRequest.builder().withName(this.ident.name()).withSchema(this.schema).withPartitionSpec(this.spec).withWriteOrder(this.writeOrder).withLocation(this.location).setProperties(this.propertiesBuilder.build()).build();
            LoadTableResponse response = RESTSessionCatalog.this.client.post(RESTSessionCatalog.this.paths.tables(this.ident.namespace()), (RESTRequest)request, LoadTableResponse.class, RESTSessionCatalog.this.headers(this.context), ErrorHandlers.tableErrorHandler());
            OAuth2Util.AuthSession session = RESTSessionCatalog.this.tableSession(response.config(), RESTSessionCatalog.this.session(this.context));
            RESTTableOperations ops = new RESTTableOperations(RESTSessionCatalog.this.client, RESTSessionCatalog.this.paths.table(this.ident), session::headers, RESTSessionCatalog.this.tableFileIO(this.context, response.config()), response.tableMetadata(), RESTSessionCatalog.this.endpoints);
            RESTSessionCatalog.this.trackFileIO(ops);
            return new BaseTable(ops, RESTSessionCatalog.this.fullTableName(this.ident), RESTSessionCatalog.this.metricsReporter(RESTSessionCatalog.this.paths.metrics(this.ident), session::headers));
        }

        @Override
        public Transaction createTransaction() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_CREATE_TABLE);
            LoadTableResponse response = this.stageCreate();
            String fullName = RESTSessionCatalog.this.fullTableName(this.ident);
            OAuth2Util.AuthSession session = RESTSessionCatalog.this.tableSession(response.config(), RESTSessionCatalog.this.session(this.context));
            TableMetadata meta = response.tableMetadata();
            RESTTableOperations ops = new RESTTableOperations(RESTSessionCatalog.this.client, RESTSessionCatalog.this.paths.table(this.ident), session::headers, RESTSessionCatalog.this.tableFileIO(this.context, response.config()), RESTTableOperations.UpdateType.CREATE, RESTSessionCatalog.createChanges(meta), meta, RESTSessionCatalog.this.endpoints);
            RESTSessionCatalog.this.trackFileIO(ops);
            return Transactions.createTableTransaction(fullName, ops, meta, RESTSessionCatalog.this.metricsReporter(RESTSessionCatalog.this.paths.metrics(this.ident), session::headers));
        }

        @Override
        public Transaction replaceTransaction() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_UPDATE_TABLE);
            if (RESTSessionCatalog.this.viewExists(this.context, this.ident)) {
                throw new AlreadyExistsException("View with same name already exists: %s", this.ident);
            }
            LoadTableResponse response = RESTSessionCatalog.this.loadInternal(this.context, this.ident, RESTSessionCatalog.this.snapshotMode);
            String fullName = RESTSessionCatalog.this.fullTableName(this.ident);
            OAuth2Util.AuthSession session = RESTSessionCatalog.this.tableSession(response.config(), RESTSessionCatalog.this.session(this.context));
            TableMetadata base = response.tableMetadata();
            ImmutableMap<String, String> tableProperties = this.propertiesBuilder.build();
            TableMetadata replacement = base.buildReplacement(this.schema, this.spec != null ? this.spec : PartitionSpec.unpartitioned(), this.writeOrder != null ? this.writeOrder : SortOrder.unsorted(), this.location != null ? this.location : base.location(), tableProperties);
            ImmutableList.Builder changes = ImmutableList.builder();
            if (replacement.changes().stream().noneMatch(MetadataUpdate.SetCurrentSchema.class::isInstance)) {
                changes.add(new MetadataUpdate.SetCurrentSchema(replacement.currentSchemaId()));
            }
            if (replacement.changes().stream().noneMatch(MetadataUpdate.SetDefaultPartitionSpec.class::isInstance)) {
                changes.add(new MetadataUpdate.SetDefaultPartitionSpec(replacement.defaultSpecId()));
            }
            if (replacement.changes().stream().noneMatch(MetadataUpdate.SetDefaultSortOrder.class::isInstance)) {
                changes.add(new MetadataUpdate.SetDefaultSortOrder(replacement.defaultSortOrderId()));
            }
            RESTTableOperations ops = new RESTTableOperations(RESTSessionCatalog.this.client, RESTSessionCatalog.this.paths.table(this.ident), session::headers, RESTSessionCatalog.this.tableFileIO(this.context, response.config()), RESTTableOperations.UpdateType.REPLACE, (List<MetadataUpdate>)((Object)changes.build()), base, RESTSessionCatalog.this.endpoints);
            RESTSessionCatalog.this.trackFileIO(ops);
            return Transactions.replaceTableTransaction(fullName, ops, replacement, RESTSessionCatalog.this.metricsReporter(RESTSessionCatalog.this.paths.metrics(this.ident), session::headers));
        }

        @Override
        public Transaction createOrReplaceTransaction() {
            try {
                return this.replaceTransaction();
            }
            catch (NoSuchTableException e) {
                return this.createTransaction();
            }
        }

        private LoadTableResponse stageCreate() {
            ImmutableMap<String, String> tableProperties = this.propertiesBuilder.build();
            CreateTableRequest request = CreateTableRequest.builder().stageCreate().withName(this.ident.name()).withSchema(this.schema).withPartitionSpec(this.spec).withWriteOrder(this.writeOrder).withLocation(this.location).setProperties(tableProperties).build();
            return RESTSessionCatalog.this.client.post(RESTSessionCatalog.this.paths.tables(this.ident.namespace()), (RESTRequest)request, LoadTableResponse.class, RESTSessionCatalog.this.headers(this.context), ErrorHandlers.tableErrorHandler());
        }
    }

    static enum SnapshotMode {
        ALL,
        REFS;


        Map<String, String> params() {
            return ImmutableMap.of("snapshots", this.name().toLowerCase(Locale.US));
        }
    }
}

