/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroWithPartnerVisitor;
import org.apache.iceberg.avro.SupportsCustomRecords;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumReader;
import org.apache.iceberg.shaded.org.apache.avro.io.Decoder;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;

public class GenericAvroReader<T>
implements DatumReader<T>,
SupportsRowPosition,
SupportsCustomRecords {
    private final Types.StructType expectedType;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private Map<String, String> renames = ImmutableMap.of();
    private final Map<Integer, Object> idToConstant = ImmutableMap.of();
    private org.apache.iceberg.shaded.org.apache.avro.Schema fileSchema = null;
    private ValueReader<T> reader = null;

    public static <D> GenericAvroReader<D> create(Schema expectedSchema) {
        return new GenericAvroReader(expectedSchema);
    }

    public static <D> GenericAvroReader<D> create(org.apache.iceberg.shaded.org.apache.avro.Schema readSchema) {
        return new GenericAvroReader(readSchema);
    }

    GenericAvroReader(Schema expectedSchema) {
        this.expectedType = expectedSchema.asStruct();
    }

    GenericAvroReader(org.apache.iceberg.shaded.org.apache.avro.Schema readSchema) {
        this.expectedType = AvroSchemaUtil.convert(readSchema).asStructType();
    }

    private void initReader() {
        this.reader = (ValueReader)AvroWithPartnerVisitor.visit(this.expectedType, this.fileSchema, new ResolvingReadBuilder(this.expectedType, this.fileSchema.getFullName()), AvroWithPartnerVisitor.FieldIDAccessors.get());
    }

    @Override
    public void setSchema(org.apache.iceberg.shaded.org.apache.avro.Schema schema) {
        this.fileSchema = schema;
        this.initReader();
    }

    @Override
    public void setClassLoader(ClassLoader newClassLoader) {
        this.loader = newClassLoader;
    }

    @Override
    public void setRenames(Map<String, String> renames) {
        this.renames = renames;
    }

    @Override
    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.reader instanceof SupportsRowPosition) {
            ((SupportsRowPosition)((Object)this.reader)).setRowPositionSupplier(posSupplier);
        }
    }

    @Override
    public T read(T reuse, Decoder decoder) throws IOException {
        return this.reader.read(decoder, reuse);
    }

    private class ResolvingReadBuilder
    extends AvroWithPartnerVisitor<Type, ValueReader<?>> {
        private final Map<Type, org.apache.iceberg.shaded.org.apache.avro.Schema> avroSchemas;

        private ResolvingReadBuilder(Types.StructType expectedType, String rootName) {
            this.avroSchemas = AvroSchemaUtil.convertTypes(expectedType, rootName);
        }

        @Override
        public ValueReader<?> record(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema record, List<ValueReader<?>> fieldResults) {
            if (partner == null) {
                return ValueReaders.skipStruct(fieldResults);
            }
            Types.StructType expected = partner.asStructType();
            List<Pair<Integer, ValueReader<?>>> readPlan = ValueReaders.buildReadPlan(expected, record, fieldResults, GenericAvroReader.this.idToConstant);
            return this.recordReader(readPlan, this.avroSchemas.get(partner), record.getFullName());
        }

        private ValueReader<?> recordReader(List<Pair<Integer, ValueReader<?>>> readPlan, org.apache.iceberg.shaded.org.apache.avro.Schema avroSchema, String recordName) {
            String className = GenericAvroReader.this.renames.getOrDefault(recordName, recordName);
            if (className != null) {
                try {
                    Class recordClass = DynClasses.builder().loader(GenericAvroReader.this.loader).impl(className).buildChecked();
                    if (IndexedRecord.class.isAssignableFrom(recordClass)) {
                        return ValueReaders.record(avroSchema, recordClass, readPlan);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return ValueReaders.record(avroSchema, readPlan);
        }

        @Override
        public ValueReader<?> union(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        @Override
        public ValueReader<?> arrayMap(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema map, ValueReader<?> keyReader, ValueReader<?> valueReader) {
            if (keyReader == ValueReaders.utf8s()) {
                return ValueReaders.arrayMap(ValueReaders.strings(), valueReader);
            }
            return ValueReaders.arrayMap(keyReader, valueReader);
        }

        @Override
        public ValueReader<?> array(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema array, ValueReader<?> elementReader) {
            return ValueReaders.array(elementReader);
        }

        @Override
        public ValueReader<?> map(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema map, ValueReader<?> valueReader) {
            return ValueReaders.map(ValueReaders.strings(), valueReader);
        }

        @Override
        public ValueReader<?> primitive(Type partner, org.apache.iceberg.shaded.org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueReaders.ints();
                    }
                    case "time-micros": {
                        return ValueReaders.longs();
                    }
                    case "timestamp-millis": {
                        ValueReader<Long> longs = ValueReaders.longs();
                        return (decoder, ignored) -> (Long)longs.read(decoder, null) * 1000L;
                    }
                    case "timestamp-micros": {
                        return ValueReaders.longs();
                    }
                    case "decimal": {
                        return ValueReaders.decimal(ValueReaders.decimalBytesReader(primitive), ((LogicalTypes.Decimal)logicalType).getScale());
                    }
                    case "uuid": {
                        return ValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    if (partner != null && partner.typeId() == Type.TypeID.LONG) {
                        return ValueReaders.intsAsLongs();
                    }
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    if (partner != null && partner.typeId() == Type.TypeID.DOUBLE) {
                        return ValueReaders.floatsAsDoubles();
                    }
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return ValueReaders.utf8s();
                }
                case FIXED: {
                    return ValueReaders.fixed(primitive);
                }
                case BYTES: {
                    return ValueReaders.byteBuffers();
                }
                case ENUM: {
                    return ValueReaders.enums(primitive.getEnumSymbols());
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

