/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum PlanningMode {
    AUTO("auto"),
    LOCAL("local"),
    DISTRIBUTED("distributed");

    private final String modeName;

    private PlanningMode(String modeName) {
        this.modeName = modeName;
    }

    public static PlanningMode fromName(String modeName) {
        Preconditions.checkArgument(modeName != null, "Mode name is null");
        if (AUTO.modeName().equalsIgnoreCase(modeName)) {
            return AUTO;
        }
        if (LOCAL.modeName().equalsIgnoreCase(modeName)) {
            return LOCAL;
        }
        if (DISTRIBUTED.modeName().equalsIgnoreCase(modeName)) {
            return DISTRIBUTED;
        }
        throw new IllegalArgumentException("Unknown planning mode: " + modeName);
    }

    public String modeName() {
        return this.modeName;
    }
}

