/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import javax.annotation.Nullable;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableTag;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Tag")
@JsonSerialize(as=ImmutableTag.class)
@JsonDeserialize(as=ImmutableTag.class)
@JsonTypeName(value="TAG")
@Value.Immutable
public interface Tag
extends Reference {
    @Override
    @Value.Parameter(order=1)
    public String getName();

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=3)
    public ReferenceMetadata getMetadata();

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=2)
    public String getHash();

    @Value.Check
    default public void checkName() {
        Validation.validateReferenceName(this.getName());
    }

    @Override
    default public Reference.ReferenceType getType() {
        return Reference.ReferenceType.TAG;
    }

    public static ImmutableTag.Builder builder() {
        return ImmutableTag.builder();
    }

    public static Tag of(String name, String hash) {
        return ImmutableTag.of(name, hash, null);
    }

    public static Tag of(String name, String hash, ReferenceMetadata metadata) {
        return ImmutableTag.of(name, hash, metadata);
    }
}

